% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_srt}
\alias{write_srt}
\title{Write subtitle data frame as SubRip text file}
\usage{
write_srt(x, path = NULL, wrap = TRUE, width = 40)
}
\arguments{
\item{x}{A subtitle data frame from \code{\link[=read_srt]{read_srt()}}.}

\item{path}{File or connection to write to.}

\item{wrap}{If \code{TRUE} (default), subtitle lines will be wrapped.}

\item{width}{If \code{wrap} is \code{TRUE}, the width of each wrapped subtitle.}
}
\value{
The path to the written file, invisibly.
}
\description{
Write subtitle data frame as SubRip text file
}
\details{
The SubRip text files format subtitles with four components separated by
a blank line:
\enumerate{
\item A numeric counter identifying each sequential subtitle
\item The time that the subtitle should appear on the screen, followed by \verb{-->}
and the time it should disappear
\item Subtitle text itself on one or more lines
\item A blank line containing no text, indicating the end of this subtitle
}
}
\examples{
# read and write without line breaks
x <- read_srt(srt_example(1), collapse = " ")
write_srt(x, tempfile(fileext = ".srt"), wrap = FALSE)
}
