% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srppp-xml.R
\name{srppp_xml_get}
\alias{srppp_xml_get}
\alias{srppp_xml_get.NULL}
\alias{srppp_xml_get.character}
\alias{srppp_xml_get_from_path}
\title{Read an XML version of the Swiss Register of Plant Protection Products}
\usage{
srppp_xml_get(from, ...)

\method{srppp_xml_get}{`NULL`}(from, ...)

\method{srppp_xml_get}{character}(from, ...)

srppp_xml_get_from_path(path, from)
}
\arguments{
\item{from}{A specification of the way to retrieve the XML}

\item{\dots}{Unused argument introduced to facilitate future extensions}

\item{path}{A path to a zipped SRPPP XML file}
}
\value{
An object inheriting from 'srppp_xml', 'xml_document', 'xml_node'
}
\description{
Read an XML version of the Swiss Register of Plant Protection Products
}
\examples{
# Try to get the current SRPPP as available from the FOAG website
\donttest{
srppp_xml_cur <- try(srppp_xml_get())
}
}
