% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-dbscan.R
\name{dbscan}
\alias{dbscan}
\alias{dbscan.default}
\alias{dbscan.qts_sample}
\title{QTS Nearest-Neighbor Clustering}
\usage{
dbscan(x, ...)

\method{dbscan}{default}(x, eps, minPts = 5, weights = NULL, borderPoints = TRUE, ...)

\method{dbscan}{qts_sample}(
  x,
  is_domain_interval = FALSE,
  transformation = c("identity", "srvf"),
  warping_class = c("none", "shift", "dilation", "affine", "bpd"),
  centroid_type = "mean",
  metric = c("l2", "normalized_l2", "pearson"),
  cluster_on_phase = FALSE,
  use_fence = FALSE,
  ...
)
}
\arguments{
\item{x}{Either a numeric matrix of data, or an object that can be coerced to
such a matrix (such as a numeric vector or a data frame with all numeric
columns) or an object of class \link{qts_sample}.}

\item{...}{additional arguments are passed on to the fixed-radius nearest
neighbor search algorithm. See \code{\link[dbscan:frNN]{frNN()}} for details on how to
control the search strategy.}

\item{eps}{size (radius) of the epsilon neighborhood. Can be omitted if
\code{x} is a frNN object.}

\item{minPts}{number of minimum points required in the eps neighborhood for
core points (including the point itself).}

\item{weights}{numeric; weights for the data points. Only needed to perform
weighted clustering.}

\item{borderPoints}{logical; should border points be assigned to clusters.
The default is \code{TRUE} for regular DBSCAN. If \code{FALSE} then border
points are considered noise (see DBSCAN* in Campello et al, 2013).}

\item{is_domain_interval}{A boolean specifying whether the sample of curves
is defined on a fixed interval. Defaults to \code{FALSE}.}

\item{transformation}{A string specifying the transformation to apply to the
original sample of curves. Choices are no transformation (\code{transformation = "identity"}) or square-root velocity function \code{transformation = "srvf"}.
Defaults to \code{"identity"}.}

\item{warping_class}{A string specifying the class of warping functions.
Choices are no warping (\code{warping_class = "none"}), shift \code{y = x + b}
(\code{warping_class = "shift"}), dilation \code{y = ax} (\code{warping_class = "dilation"}), affine \code{y = ax + b} (\code{warping_class = "affine"}) or
boundary-preserving diffeomorphism (\code{warping_class = "bpd"}). Defaults to
\code{"none"}.}

\item{centroid_type}{A string specifying the type of centroid to compute.
Choices are \code{"mean"}, \code{"median"} \code{"medoid"}, \code{"lowess"} or \code{"poly"}.
Defaults to \code{"mean"}. If LOWESS appproximation is chosen, the user can
append an integer between 0 and 100 as in \code{"lowess20"}. This number will be
used as the smoother span. This gives the proportion of points in the plot
which influence the smooth at each value. Larger values give more
smoothness. The default value is 10\%. If polynomial approximation is
chosen, the user can append an positive integer as in \code{"poly3"}. This
number will be used as the degree of the polynomial model. The default
value is \code{4L}.}

\item{metric}{A character string specifying the distance measure to be used.
This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"} if \code{x} is not a QTS sample.
Otherwise, it must be one of \code{"l2"}, \code{"pearson"} or \code{"dtw"}.}

\item{cluster_on_phase}{A boolean specifying whether clustering should be
based on phase variation or amplitude variation. Defaults to \code{FALSE} which
implies amplitude variation.}

\item{use_fence}{A boolean specifying whether the fence algorithm should be
used to robustify the algorithm against outliers. Defaults to \code{FALSE}. This
is used only when \code{warping_class != "srvf"}.}
}
\value{
An object of class \code{\link[stats:kmeans]{stats::kmeans}} or \code{\link[stats:hclust]{stats::hclust}} or
\code{dbscan_fast} if the input \code{x} is NOT of class \code{\link{qts_sample}}. Otherwise,
an object of class \code{qtsclust} which is effectively a list with four
components:
\itemize{
\item \code{qts_aligned}: An object of class \code{\link{qts_sample}} storing the sample of
aligned QTS;
\item \code{qts_centers}: A list of objects of class \code{\link{qts}} representing the centers
of the clusters;
\item \code{best_clustering}: An object of class \code{\link[fdacluster:caps]{fdacluster::caps}} storing the
results of the best k-mean alignment result among all initialization that
were tried.
\item \code{call_name}: A string storing the name of the function that was used to
produce the clustering structure;
\item \code{call_args}: A list containing the exact arguments that were passed to
the function \code{call_name} that produced this output.
}
}
\description{
This function massages the input quaternion time series to apply DBSCAN
clustering on them, with the possibility of separating amplitude and phase
variability and of choosing the source of variability through which clusters
should be searched.
}
\examples{
out <- dbscan(vespa64$igp[1:10])
plot(out)
}
