% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-sample-class.R
\name{qts_sample}
\alias{qts_sample}
\alias{as_qts_sample}
\alias{is_qts_sample}
\title{QTS Sample Class}
\usage{
as_qts_sample(x)

is_qts_sample(x)
}
\arguments{
\item{x}{A list of \code{\link[tibble:tibble]{tibble::tibble}}s, each of which with columns
\code{time}, \code{w}, \code{x}, \code{y} and \code{z}.}
}
\value{
An object of class \code{\link{qts_sample}}.
}
\description{
A collection of functions that implements the QTS sample class. It currently
provides the \code{as_qts_sample()} function for QTS sample coercion of lists of
\code{\link{qts}} objects and the \code{is_qts_sample()} function for checking if
an object is a QTS sample.
}
\details{
A QTS sample is a collection of quaternion time series (QTS), each of which
is stored as a \code{\link[tibble]{tibble}} with 5 columns:
\itemize{
\item \code{time}: A first column specifying the time points at which quaternions were
collected;
\item \code{w}: A second column specifying the first coordinate of the collected
quaternions;
\item \code{x}: A third column specifying the second coordinate of the collected
quaternions;
\item \code{y}: A fourth column specifying the third coordinate of the collected
quaternions;
\item \code{z}: A fifth column specifying the fourth coordinate of the collected
quaternions.
}
}
\examples{
x <- vespa64$igp
y <- as_qts_sample(x)
is_qts_sample(x)
is_qts_sample(y)
}
