% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tournaments.R
\name{get_tournaments}
\alias{get_tournaments}
\title{Get tournaments from SquashInfo}
\usage{
get_tournaments(year = 2020, world_tour = TRUE)
}
\arguments{
\item{year}{integer indicating the tournament year. Must be one of 2019 or 2020.}

\item{world_tour}{logical indicating whether to only return PSA World Tour tournaments.}
}
\value{
Tibble containing the league, competition category, name, date, city, and country.
}
\description{
Given a year, \code{get_tournaments()} returns data for PSA World Tour tournaments and other events.
}
\note{
This function only returns tournaments from 2019 and 2020, as any other data are not available to non-premium members on SquashInfo.
}
\examples{

## Get data on 2020 PSA World Tour tournaments
\donttest{get_tournaments()}

## Get data on 2019 non-PSA World Tour tournaments
\donttest{get_tournaments(2019, world_tour = FALSE)}

}
\references{
\url{http://www.squashinfo.com/results}
}
