% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makecrm.R
\name{makecrm}
\alias{makecrm}
\title{Defining a spatial correlogram model}
\usage{
makecrm(acf0, range, model, ...)
}
\arguments{
\item{acf0}{Aurocorrelation function value at distance near 0. Default is 1. Must
fall in interval [0,1].}

\item{range}{Range parameter of the correlogram model component.}

\item{model}{Model type, e.g. "Exp", "Sph", "Gau", "Mat" that vgm() accepts.
Calling vgm() without a model argument returns a data.frame with available
models.}

\item{...}{Arguments that will be passed to crm2vgm() that vgm() accepts.}
}
\value{
An object of a class "SpatialCorrelogramModel". This is a list collating provided arguments.
}
\description{
Function that generates a spatial correlogram model, an object of class "SpatialCorrelogramModel".
}
\details{
For the spatial variables allowed autocorrelation functions are listed in Table 4.1 of the
gstat manual (\url{http://www.gstat.org/gstat.pdf}). Spatial correlation
assumes stationarity, i.e. correlation depends only on the separation
distance between points in space. Anisotropy is allowed (http://www.gstat.org/gstat.pdf). No nested
models are allowed in the current version.
}
\examples{

mycormodel <- makecrm(acf0 = 0.8, range = 300, model = "Exp")
mycormodel

}
\author{
Kasia Sawicka, Gerard Heuvelink
}

