% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsurvey.R
\docType{package}
\name{spsurvey-package}
\alias{spsurvey}
\alias{spsurvey-package}
\title{spsurvey: Spatial Survey Design and Analysis}
\description{
This package provides functions for design and analysis of probability
surveys.  The functions in spsurvey can select generalized random-tesselation
stratified (GRTS) and independent random sample (IRS) survey designs.
Although the function can be used with a wide range of environmental survey
designs, the spsurvey analysis functions were written to accommodate data
generated by a GRTS sampling design.  The functions in spsurvey are
applicable to finite (discrete units, zero-dimensional), linear
(one-dimensional), and areal (two-dimensional) resources.  Examples of these
resource are lakes in the United States (a finite resource), rivers and
streams in Oregon (a linear resource), and Chesapeake Bay (an areal
resource). The design functions can select stratified and unstratified
sampling designs. The analysis functions can accommodate stratified and
unstratified designs, both of which can utilize single-stage or two-stage
sampling.  Analytical capabilities accommodate both categorical and
continuous data.  For categorical data, estimates of proportion and size of
each category (class) can be obtained.  For a finite resource, size is the
number of units in the resource.  For an extensive (linear or areal)
resource, size is the measure (extent) of the resource, i.e., length, area,
or volume.  In addition, for categorical data that contains bivariate (two
categories) response variables and bivariate explanatory (stressor)
variables, relative risk estimates and attributable risk estimates can be
calculated.  For continuous data, estimates of the cumulative distribution
function (CDF) and percentiles can be obtained in addition to estimation of
the population mean, total, variance, and standard deviation. Optionally, for
continuous data, estimation of the deconvoluted CDF and estimation of
percentiles using the deconvoluted CDF are available.
}
\author{
\strong{Maintainer}: Marc Weber \email{Weber.Marc@epa.gov}

Authors:
\itemize{
  \item Tom Kincaid \email{Kincaid.Tom@epa.gov}
  \item Tony Olsen \email{Olsen.Tony@epa.gov}
}

Other contributors:
\itemize{
  \item Don Stevens [contributor]
  \item Christian Platt [contributor]
  \item Denis White [contributor]
  \item Richard Remington [contributor]
}

}
