% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcdf.size.prop.R
\name{dcdf.size.prop}
\alias{dcdf.size.prop}
\title{Deconvoluted Size-Weighted Cumulative Distribution Function for Proportion}
\usage{
dcdf.size.prop(g, wgt, cluster.ind, cluster, wgt1, swgt, swgt1)
}
\arguments{
\item{g}{Vector of the values of the deconvolution function g(.) evaluated
at a specified value for the response value for each site.}

\item{wgt}{Vector of the final adjusted weight (inverse of the sample
inclusion probability) for each site, which is either the weight for a
single- stage sample or the stage two weight for a two-stage sample.}

\item{cluster.ind}{Logical value that indicates whether the sample is a
two- stage sample, where TRUE = a two-stage sample and FALSE = not a
two-stage sample.}

\item{cluster}{Vector of the stage one sampling unit (primary sampling unit
or cluster) code for each site.}

\item{wgt1}{Vector of the final adjusted stage one weight for each site.}

\item{swgt}{Vector of the size-weight for each site, which is the stage two
size-weight for a two-stage sample.}

\item{swgt1}{Vector of the stage one size-weight for each site.}
}
\value{
The deconvoluted CDF estimate.
}
\description{
This function calculates an estimate of the size-weighted, deconvoluted
cumulative distribution function (CDF) for the proportion of a discrete
resource. The simulation extrapolation deconvolution method (Stefanski and
Bay, 1996) is use to deconvolute measurement error variance from the
response.  The Horvitz-Thompson ratio estimator, i.e., the ratio of two
Horvitz-Thompson estimators, is used to calculate the estimate.  The
numerator of the ratio estimates the size-weighted total of the resource
equal to or less than a specified value.  The denominator of the ratio
estimates the sum of the size-weights for the resource.  The function can
accomodate single-stage and two-stage samples.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
