% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sncFun.02110.R
\name{sncFun.02110}
\alias{sncFun.02110}
\title{Unimodal Kosugi Non-Capillary Saturation Model}
\usage{
sncFun.02110(p_snc, h)
}
\arguments{
\item{p_snc}{vector of the 2 Kosugi saturation model parameters, and h0 sensitve and has to be given as:
\tabular{lll}{
      \code{hm}\tab{air entry pressure head [cm]}\cr
      \code{sigma}\tab{width of pore size distribution [ - ]}\cr
      \code{h0}\tab{pressure head representing oven dryness given in pF, i.e. log[10](|pressure head| [cm])}\cr
         }}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{snc}{non-capillary saturation}
}
\description{
Analytical implementation of the non-capillary saturation function for the \insertCite{Kosugi.1996}{spsh}.
}
\details{
The function is Eq. Table 1-B in insertRef{Streck.2020}{spsh}
The analytical solution presented in \code{sncFun.02110} only requires the Kosugi specific model parameters and \code{h0}
}
\examples{
p      <- c(0.1, 0.4, 100, 2, 100, .5)
# add h0
p_snc  <- c(p[3:4], 6.8)
h      <- 10^seq(-2, 6.8, length = 197)
Se     <- shypFun.02110(p, h)$Se
snc    <- sncFun.02110(p_snc, h)
}
\references{
\insertRef{Kosugi.1996}{spsh}
\insertRef{Streck.2020}{spsh}
}
