% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sps_timeline.R
\name{spsTimeline}
\alias{spsTimeline}
\alias{updateSpsTimeline}
\title{A shiny timeline component}
\usage{
spsTimeline(id, up_labels, down_labels, icons, completes)

updateSpsTimeline(
  session,
  id,
  item_no,
  complete = TRUE,
  up_label = NULL,
  down_label = NULL
)
}
\arguments{
\item{id}{html ID of the timeline if you are using shiny modules:
use namespace function to create the ID but DO NOT use namespace function
on server.}

\item{up_labels}{a vector of strings, text you want to display on top of each
timeline item, usually like year number. If you do not want any text for a
certain items, use \code{""} to occupy the space.}

\item{down_labels}{a vector of strings, text you want to display at the
bottom of each timeline item.}

\item{icons}{a list of icon objects. If you do not want an icon for certain
items, use \code{div()} to occupy the space.}

\item{completes}{a vector of TRUE or FALSE, indicating if the items are
completed or not. Completed items will become green.}

\item{session}{current shiny session}

\item{item_no}{integer, which item number counting from left to right you
want to update}

\item{complete}{bool, is this item completed or not}

\item{up_label}{the \code{item_no} associated up label to update}

\item{down_label}{the \code{item_no} associated down label to update}
}
\value{
returns a shiny component
}
\description{
This time time is horizontal, use \strong{spsTimeline} to define it and
use \strong{updateSpsTimeline} on server to update it.
}
\details{
\code{up_labels}, \code{down_labels}, \code{icons}, \code{completes} must have the same
length.
}
\examples{
if(interactive()){
    ui <- fluidPage(
        column(6,
               spsTimeline(
                   "b",
                   up_labels = c("2000", "2001"),
                   down_labels = c("step 1", "step 2"),
                   icons = list(icon("table"), icon("gear")),
                   completes = c(FALSE, TRUE)
               )
        ),
        column(6,
               actionButton("a", "complete step 1"),
               actionButton("c", "uncomplete step 1"))

    )

    server <- function(input, output, session) {
        observeEvent(input$a, {
            updateSpsTimeline(session, "b", 1, up_label = "0000", down_label = "Finish")
        })
        observeEvent(input$c, {
            updateSpsTimeline(session, "b", 1, complete = FALSE,
                              up_label = "9999", down_label = "Step 1")
        })
    }

    shinyApp(ui, server)
}
}
