% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_qmap.R
\name{methods_qmap}
\alias{methods_qmap}
\title{Method for class qmap}
\arguments{
\item{x}{object of class \emph{qmap}}

\item{ci}{confidence level for the difference of probabilities of symbols in `plot` method.
Default \code{ci = 0.95}}

\item{...}{further arguments passed to or from other methods.}
}
\description{
A function to plot the difference in frequencies of symbols of each map.
 The \code{plot()} function to obtain the plot.
 The argument \code{ci} select the confidence level. \cr
}
\examples{
# Example 1:
N <- 100
cx <- runif(N)
cy <- runif(N)
coor <- cbind(cx,cy)
p <- c(1/6,3/6,2/6)
rho = 0.5
listw <- spdep::nb2listw(spdep::knn2nb(spdep::knearneigh(cbind(cx,cy), k = 4)))
fx <- dgp.spq(list = listw, p = p, rho = rho)
q.test <- Q.test(fx = fx, coor = coor, m = 3, r = 1)
plot(q.test)
}
\references{
\itemize{
    \item Ruiz M, López FA and A Páez (2011).
    Comparison of Thematic Maps Using Symbolic Entropy.
      \emph{International Journal of Geographical Information Science},  26, 413-439.
    \item Ruiz, M., López, F., and Páez, A. (2021).
    A test for global and local homogeneity of categorical data based on spatial runs.
      \emph{working paper}.
  }
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Antonio Páez \tab \email{paezha@gmail.com} \cr
  Manuel Ruiz \tab \email{manuel.ruiz@upct.es} \cr
  }
}
