% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximations.R
\name{GetBMA}
\alias{GetBMA}
\title{Compute the Bayesian Model average}
\usage{
GetBMA(fit, win = fit$data$window, burnin = fit$L/10, LL = 100,
  zlims = c(0, 0))
}
\arguments{
\item{fit}{Object of class \code{bdmcmc_res}.}

\item{win}{An object of class \code{\link[spatstat]{owin}}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{LL}{Length of the side of the square grid.
The density or intensity is calculated on an L * L grid.
The larger this value is, the slower the calculation,
but the better the approximation as well as the smoother the resulting plots.}

\item{zlims}{The limits of the z axis. Defaults to [0,max(z)].}
}
\value{
An image as an object of class \code{\link[spatstat]{im.object}}.
}
\description{
This function uses the posterior realizations
from a \code{\link{est_mix_bdmcmc}} call, to compute the
Bayesian Model Average across different number of components
and returns the fitted Poisson point process with mixture of normals intensity surface.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#GetBMA}
}
\examples{
\donttest{
fit=est_mix_bdmcmc(pp = spatstat::redwood, m = 5)
BMA=GetBMA(fit)
burnin=.1*fit$L
title1 = paste("Bayesian model average of",fit$L-burnin,"posterior realizations")
plotmix_3d(BMA,title1=title1)
plot_density(as.data.frame(BMA))+ggplot2::ggtitle("Bayesian model average intensity surface")
plot_density(as.data.frame(BMA),TRUE)+ggplot2::ggtitle(
 "Contours of the Bayesian model average intensity surface")}

}
\seealso{
\code{\link{est_mix_bdmcmc}},
\code{\link{plotmix_3d}},
\code{\link{plot_density}}
}
\author{
Sakis Micheas
}
