% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-baseball.R
\name{baseball_catchers_box}
\alias{baseball_catchers_box}
\title{The catcher's box. This is where the catcher is located on defense, usually
marked by two white lines and a back line as well. The box may take various
shapes, which are controlled by the \code{catchers_box_shape} parameter}
\usage{
baseball_catchers_box(
  catchers_box_depth = 0,
  catchers_box_width = 0,
  batters_box_length = 0,
  batters_box_y_adj = 0,
  catchers_box_shape = "rectangle",
  catchers_box_thickness = 0,
  home_plate_circle_radius = 0
)
}
\arguments{
\item{catchers_box_depth}{The distance from the back tip of home plate to the
back edge of the catcher's box}

\item{catchers_box_width}{The distance between the outer edges of the
catcher's box at the widest point}

\item{batters_box_length}{The length of the batter's box (in the y direction)
measured from the outside of the chalk lines}

\item{batters_box_y_adj}{The shift off of center in the y direction that the
batter's box is to be moved to properly align}

\item{catchers_box_shape}{A string representing the shape of the catcher's
box to draw}

\item{catchers_box_thickness}{The thickness of the chalk lines that comprise
the catcher's box}

\item{home_plate_circle_radius}{The radius of the circle around home plate}
}
\value{
A data frame containing the bounding box of the catcher's box
}
\description{
The catcher's box. This is where the catcher is located on defense, usually
marked by two white lines and a back line as well. The box may take various
shapes, which are controlled by the \code{catchers_box_shape} parameter
}
\keyword{internal}
