% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmath.R
\name{as_plotmath.spar}
\alias{as_plotmath.spar}
\title{Convert One Spork to Plotmath}
\usage{
\method{as_plotmath}{spar}(
  x,
  unrecognized = getOption("plotmath_unrecognized", spork::plotmathToken),
  ...
)
}
\arguments{
\item{x}{spar}

\item{unrecognized}{function to process unrecognized tokens}

\item{...}{passed to \code{unrecognized}}
}
\value{
character
}
\description{
Converts one spork to plotmath.
See description for \code{\link{as_spork}}.
Unrecognized tokens are returned
unmodified by default.
Otherwise, backslashes and single quotes are escaped,
and the result is wrapped in single quotes.
See \code{\link{plotmathToken}}.
}
\details{
Experimental support is implemented for
the sequence "backslash n" (\code{'\\n'}).
It tries to break the expression at the
point indicated, and stack the results.
Active subscripts and superscripts
are closed in advance, preventing
these from breaking across lines.
}
\examples{
library(magrittr)
'V_c./F' \%>\% as_spork \%>\% as_plotmath
'AUC_ss' \%>\% as_spork \%>\% as_plotmath
'C_max_ss' \%>\% as_spork \%>\% as_plotmath
'var^eta_j' \%>\% as_spork \%>\% as_plotmath
'& \% $ # \\\\_ { } ~ \\\\^ \\\\' \%>\% as_spork \%>\% as_plotmath
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_plotmath
'one joule (`Omega`) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_plotmath
'one joule (\\\\`Omega\\\\`) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_plotmath
}
\seealso{
plotmathToken

Other interface: 
\code{\link{as.expression.plotmath}()},
\code{\link{as_html.spar}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.spar}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spork.character}()},
\code{\link{htmlToken}()},
\code{\link{latexToken}()},
\code{\link{plotmathToken}()}

Other plotmath: 
\code{\link{[.plotmath}()},
\code{\link{[[.plotmath}()},
\code{\link{as.expression.plotmath}()},
\code{\link{as.png.plotmath}()},
\code{\link{as_plotmath.greek}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_plotmath}()},
\code{\link{concatenate.plotmath}()},
\code{\link{ggplot.plotmath}()},
\code{\link{goodToken}()},
\code{\link{plotmathToken}()}

Other spar: 
\code{\link{as_spar.default}()},
\code{\link{as_spar.spork}()},
\code{\link{as_spar}()}
}
\concept{interface}
\concept{plotmath}
\concept{spar}
