% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecv.acc.R
\name{vecv}
\alias{vecv}
\title{Variance explained by predictive models based on cross-validation}
\usage{
vecv(obs, pred)
}
\arguments{
\item{obs}{observation values of validation samples.}

\item{pred}{prediction values of predictive models for validation samples.}
}
\value{
a numeric number.
}
\description{
vecv is used to calculate the variance explained by predictive
models based on cross-validation. The vecv is based on the differences between
the predicted values for, and the observed values of, validation samples
for cross-validation. It measures the proportion of variation in the
validation data explained by the predicted values obtained from predictive
models based on cross-validation.
}
\examples{
set.seed(1234)
x <- sample(1:30, 30)
e <- rnorm(30, 1)
y <- x + e
vecv(x, y)

y <- 0.8 * x + e
vecv(x, y)

}
\references{
Li, J., 2016. Assessing spatial predictive models in the environmental sciences: accuracy.
measures, data variation and variance explained. Environmental Modelling & Software 80 1-8.
}
\author{
Jin Li
}
