% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avi.R
\name{avi}
\alias{avi}
\title{Averaged variable importance based on random forest}
\usage{
avi(
  trainx,
  trainy,
  mtry = if (!is.null(trainy) && !is.factor(trainy)) max(floor(ncol(trainx)/3), 1) else
    floor(sqrt(ncol(trainx))),
  ntree = 500,
  importance = TRUE,
  maxk = c(4),
  nsim = 100,
  corr.threshold = 0.5,
  ...
)
}
\arguments{
\item{trainx}{a dataframe or matrix contains columns of predictor variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{mtry}{a function of number of remaining predictor variables to use as
the mtry parameter in the randomForest call.}

\item{ntree}{number of trees to grow. This should not be set to too small a
number, to ensure that every input row gets predicted at least a few times.
By default, 500 is used.}

\item{importance}{imprtance of predictive variables.}

\item{maxk}{maxk split value. By default, 4 is used.}

\item{nsim}{iteration number. By default, 100 is used.}

\item{corr.threshold}{correlation threshold and the defaults value is 0.5.}

\item{...}{other arguments passed on to randomForest.}
}
\value{
A list with the following components: averaged variable importance
(avi), column number of importance variable in trainx arranged from the most
important to the least important (impvar), names of importance variable
arranged from the most important to the least important (impvar2)
}
\description{
This function is to derive an averaged variable importance based
on random forest
}
\examples{
\dontrun{
data(petrel)
set.seed(1234)
avi1 <- avi(petrel[, c(1,2, 6:9)], petrel[, 5], nsim = 10)
avi1

avi1 <- avi(petrel[, c(1), drop = FALSE], petrel[, 5], nsim = 10)
avi1
}

}
\references{
Smith, S.J., Ellis, N., Pitcher, C.R., 2011. Conditional variable
importance in R package extendedForest.

Li, J. 2013. Predicting the spatial distribution of seabed gravel content
using random forest, spatial interpolation methods and their hybrid methods.
Pages 394-400  The International Congress on Modelling and Simulation
(MODSIM) 2013, Adelaide.

Liaw, A. and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.
}
\author{
Jin Li
}
