% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listCol_w.R
\name{listCol_w}
\alias{listCol_w}
\title{Flatten a Column Stored as a List}
\usage{
listCol_w(inDT, listcol, drop = TRUE, fill = NA_character_)
}
\arguments{
\item{inDT}{The input dataset.}

\item{listcol}{The name of the column stored as a \code{list}.}

\item{drop}{Logical. Should the original column be dropped? Defaults to \code{TRUE}.}

\item{fill}{The desired fill value. Defaults to \code{NA_character_}.}
}
\value{
A \code{data.table}.
}
\description{
Flattens a column stored as a \code{list} into a wide form.
}
\examples{

dat <- data.frame(A = 1:3, B = I(list(c(1, 2), c(1, 3, 5), c(4))))
listCol_w(dat, "B")

}
\seealso{
\code{\link{listCol_l}} to unlist a \code{list} column into a "long" format.
}
\author{
Ananda Mahto
}
