% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_splits.R
\name{generate_splits}
\alias{generate_splits}
\title{Generate Splits Possibilities}
\usage{
generate_splits(p, G, use.all = TRUE, fix.partition = NULL, verbose = TRUE)
}
\arguments{
\item{p}{Number of variables or objects to split.}

\item{G}{Number of groups into which the variables are split.}

\item{use.all}{Boolean variable to determine if all variables must be used (default is TRUE).}

\item{fix.partition}{Optional matrix with G columns (or list if more than one value of G) indicating the partitions (in each row) to be considered for the splits.}

\item{verbose}{Boolean variable to determine if console output for cross-validation progress is printed (default is TRUE).}
}
\value{
A matrix with the different splits of the variables in the groups.
}
\description{
\code{generate_splits} returns a matrix with the different splits of the variables in reach row.
}
\examples{
# Generating the possible splits of 6 variables in 3 groups
# Using all the variables
split.3groups.all <- generate_splits(6, 3)
split.3groups.all
# Without using all the variables
split.3groups <- generate_splits(6, 3, use.all=FALSE)
split.3groups

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
