% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.R
\name{deriv}
\alias{deriv}
\alias{deriv.bSpline2}
\alias{deriv.cSpline}
\alias{deriv.dbs}
\alias{deriv.iSpline}
\alias{deriv.ibs}
\alias{deriv.mSpline}
\title{Derivative of Splines}
\usage{
\method{deriv}{bSpline2}(expr, derivs = 1L, ...)

\method{deriv}{dbs}(expr, derivs = 1L, ...)

\method{deriv}{ibs}(expr, derivs = 1L, ...)

\method{deriv}{mSpline}(expr, derivs = 1L, ...)

\method{deriv}{iSpline}(expr, derivs = 1L, ...)

\method{deriv}{cSpline}(expr, derivs = 1L, ...)
}
\arguments{
\item{expr}{Objects of class \code{bSpline2}, \code{ibs}, \code{dbs},
\code{mSpline}, \code{iSpline}, or \code{cSpline}, etc.}

\item{derivs}{A positive integer specifying the order of derivatives. By
default, it is \code{1L} for the first derivative.}

\item{...}{Other arguments for further usage.}
}
\value{
A matrix of dimension \code{length(x)} by
\code{df = degree + length(knots)} (plus one if intercept is included).
Attributes that correspond to the arguments specified are returned
for usage for other function in this package.
}
\description{
\code{deriv} methods that obtain derivative of given order of B-splines,
M-spline, I-splines, and C-splines, etc. At knots, the derivative is defined
to be the right derivative. By default, the function returns the first
derivative. For derivatives of order greater than one, the nested call such
as \code{deriv(deriv(expr))} is supported but not recommended. For a better
performance, argument \code{derivs} should be specified instead.
}
\details{
The function is designed for most of the objects generated from this
package. It internally extracts necessary information about the input spline
basis matrix from its attributes. So the function will not work if some
attribute is not available.
}
\examples{
library(splines2)
x <- c(seq.int(0, 1, 0.1), NA)  # NA's will be kept.
knots <- c(0.3, 0.5, 0.6)

## integal of B-splines and the corresponding B-splines integrated
ibsMat <- ibs(x, knots = knots)
bsMat <- bSpline(x, knots = knots)

## the first derivative
d1Mat <- deriv(ibsMat)
stopifnot(all.equal(bsMat, d1Mat, check.attributes = FALSE))

## the second derivative
d2Mat1 <- deriv(bsMat)
d2Mat2 <- deriv(ibsMat, derivs = 2L)
## nested calls are supported but not recommended
d2Mat3 <- deriv(deriv(ibsMat))
stopifnot(all.equal(d2Mat1, d2Mat2, d2Mat3, check.attributes = FALSE))

## C-splines, I-splines, M-splines and the derivatives
csMat <- cSpline(x, knots = knots, scale = FALSE)
isMat <- iSpline(x, knots = knots)
stopifnot(all.equal(isMat, deriv(csMat), check.attributes = FALSE))

msMat <- mSpline(x, knots = knots)
stopifnot(all.equal(msMat, deriv(isMat), deriv(csMat, 2),
                    deriv(deriv(csMat)), check.attributes = FALSE))

dmsMat <- mSpline(x, knots = knots, derivs = 1)
stopifnot(all.equal(dmsMat, deriv(msMat), deriv(isMat, 2),
                    deriv(deriv(isMat)), deriv(csMat, 3),
                    deriv(deriv(deriv(csMat))), check.attributes = FALSE))
}
\references{
De Boor, Carl. (1978). \emph{A practical guide to splines}.
Vol. 27. New York: Springer-Verlag.
}
\seealso{
\code{\link{bSpline}} for B-splines;
\code{\link{ibs}} for integral of B-splines;
\code{\link{mSpline}} for M-splines;
\code{\link{iSpline}} for I-splines;
\code{\link{cSpline}} for C-splines.
}

