% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_density}
\alias{proto_density}
\alias{proto_density1d}
\title{Tour proto for data, 1D density, with rug marks}
\usage{
proto_density(
  aes_args = list(),
  identity_args = list(alpha = 0.7),
  row_index = NULL,
  density_position = c("identity", "stack", "fill"),
  rug_shape = c(3, 142, 124, NULL)
)
}
\arguments{
\item{aes_args}{A list of arguments to call inside of aes().
aesthetic mapping of the primary geom. For example,
\code{geom_point(aes(color = my_fct, shape = my_fct))} becomes
\code{aes_args = list(color = my_fct, shape = my_fct)}.}

\item{identity_args}{A list of static, identity arguments passed into
the primary geom. For instance,
\code{geom_point(size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.
Also passes more foundational arguments such as stat and position, though
these have been tested less.}

\item{row_index}{A numeric or logical index of rows to subset to.
Defaults to NULL, all observations.}

\item{density_position}{The \code{ggplot2} position of \code{geom_density()}. Either
c("identity", "stack"), defaults to "identity". Warning: "stack" does not
work with \code{animate_plotly()} at the moment.}

\item{rug_shape}{Numeric, the number of the shape to make rug marks.
Expects either 3 142, 124 or NULL, '+', '|' (plotly), '|' (ggplot2)
respectively. Defaults to 3.}
}
\description{
Adds \code{geom_density()} and \code{geom_rug()} of the projected data. Density
\code{postion = "stack"} does not work with \code{animate_plotly()}, GH issue is open.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
gt_path <- save_history(dat, grand_tour(), max = 3)

ggt <- ggtour(gt_path, dat, angle = .3) +
  proto_density(aes_args = list(color = clas, fill = clas)) +
  proto_basis1d() +
  proto_origin1d()
\donttest{
animate_plotly(ggt)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
