% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_covar.R
\name{covar.plot}
\alias{covar.plot}
\title{Plot wavelet variance/covariance}
\usage{
covar.plot(formula, data, coord, wavelet = "haar", wtrafo = "dwt",
  plot = "covar", customize_plot = NULL)
}
\arguments{
\item{formula}{With specified notation according to names in data frame.}

\item{data}{Data frame.}

\item{coord}{A matrix of 2 columns with
corresponding x,y-coordinates which have to be integer.}

\item{wavelet}{Type of wavelet: \code{haar}, \code{d4}, or \code{la8}.}

\item{wtrafo}{Type of wavelet transform: \code{dwt} or \code{modwt}.}

\item{plot}{Either \code{var} for wavelet variance analysis
or \code{covar} for wavelet covariance analysis.}

\item{customize_plot}{Additional plotting parameters passed to \code{ggplot}.
NOW DEPRECATED}
}
\value{
A list containing

 1. \code{result} =  a vector of results.

 2. \code{plot} = a \code{ggplot} object
}
\description{
Plots the wavelet variance or covariance for the specified formula.
The scale-dependent results are graphically displayed.
}
\details{
Each variable or pair of variables in \code{formula} is passed to \code{wavevar} or
\code{wavecovar} internally, and the result is plotted as a function of \code{level}.
}
\examples{
data(carlinadata)
coords <- carlinadata[,4:5]

covariance <- covar.plot(carlina.horrida ~ aridity + land.use - 1,
                         data = carlinadata,
                         coord = coords,
                         wavelet = "d4",
                         wtrafo = 'modwt',
                         plot = 'covar')

covariance$plot
covariance$result

variance <- covar.plot(carlina.horrida ~ aridity + land.use - 1,
                       data = carlinadata,
                       coord = coords,
                       wavelet = "d4",
                       wtrafo = 'modwt',
                       plot = 'var')

variance$plot
variance$result

}
\seealso{
\code{\link{wavevar}}, \code{\link{wavecovar}}
}
\author{
Gudrun Carl
}
