% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_Calc.R
\name{aic.calc}
\alias{aic.calc}
\title{Akaike Information Criterion with correction for sample size}
\usage{
aic.calc(formula, family, data, mu, n.eff = NULL)
}
\arguments{
\item{formula}{A model formula}

\item{family}{Family used to fit the model. \code{gaussian}, \code{binomial}, or \code{poisson} are supported}

\item{data}{A data frame}

\item{mu}{Fitted values from a model}

\item{n.eff}{Effective number of observations. Default is NULL}
}
\value{
A list with the following components
\describe{
  \item{\code{loglik}}{Log likelihood of the model}
  \item{\code{df}}{Degrees of freedom}
  \item{\code{AIC}}{AIC score for the specified model}
  \item{\code{AICc}}{AIC score corrected for small sample sizes}
}
}
\description{
Calculates AIC and AICc
}
\examples{
data(musdata)
coords <- musdata[ ,4:5]
mglm <- glm(musculus ~ pollution + exposure, "poisson", musdata)

aic <- aic.calc(musculus ~ pollution + exposure, "poisson", musdata,
                mglm$fitted)
aic$AIC


}
\author{
Gudrun Carl, Sam Levin
}
