% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_spflow-model-meta.R,
%   R/class_spflow-model-children.R
\docType{class}
\name{spflow_model-class}
\alias{spflow_model-class}
\alias{coef,spflow_model-method}
\alias{fitted,spflow_model-method}
\alias{nobs,spflow_model-method}
\alias{predict,spflow_model-method}
\alias{resid,spflow_model-method}
\alias{results,spflow_model-method}
\alias{sd_error,spflow_model-method}
\alias{spflow_model_ols-class}
\alias{spflow_model_mle-class}
\alias{spflow_model_s2sls-class}
\alias{spflow_model_mcmc-class}
\alias{logLik,spflow_model_mle-method}
\alias{varcov,spflow_model_mle_s2sls_ols-method}
\alias{mcmc_results,spflow_model_mcmc-method}
\title{Class spflow_model}
\usage{
\S4method{coef}{spflow_model}(object)

\S4method{fitted}{spflow_model}(object)

\S4method{nobs}{spflow_model}(object)

\S4method{predict}{spflow_model}(object, ..., type = "BP")

\S4method{resid}{spflow_model}(object)

\S4method{results}{spflow_model}(object)

\S4method{sd_error}{spflow_model}(object)

\S4method{logLik}{spflow_model_mle}(object)

\S4method{varcov}{spflow_model_mle_s2sls_ols}(object)

\S4method{mcmc_results}{spflow_model_mcmc}(object)
}
\arguments{
\item{object}{A \code{\link[=spflow_model-class]{spflow_model-class()}}}

\item{...}{Further arguments passed to the prediction function}

\item{type}{A character declaring the type of prediction (for now only "BP")}
}
\description{
An S4 class that contains the estimation results of spatial econometric
interaction models estimated by the \code{\link[=spflow]{spflow()}} function.

There are four subclasses that are specific to the chosen estimation method
(OLS, MLE, Bayesian MCMC or S2SLS).
They contain some additional information specific to the corresponding
method but most behaviours and data are identical among them.
}
\section{Slots}{

\describe{
\item{\code{estimation_results}}{A data.frame that contains the main \code{\link[=results]{results()}} of the estimation}

\item{\code{estimation_control}}{A list that contains all control parameters of the estimation
(see \code{\link[=spflow_control]{spflow_control()}})}

\item{\code{N}}{A numeric that corresponds to the number of origin-destination pairs
(the sample size in this model)}

\item{\code{sd_error}}{A numeric representing the standard deviation of the residual}

\item{\code{R2_corr}}{A numeric that serves as a goodness of fit criterion.
The R2_corr is computed as squared correlation between the fitted values
and the observed values of the dependent variable.}

\item{\code{resid}}{A numeric vector of regression residuals}

\item{\code{fitted}}{A numeric vector of fitted values computed as the in sample prediction
trend signal (TS) prediction described by @Goulard2017}

\item{\code{spatial_filter_matrix}}{A matrix (can be sparse) or NULL}

\item{\code{design_matrix}}{A matrix (can be sparse) or NULL}

\item{\code{varcov}}{A matrix or NULL}

\item{\code{ll}}{A numeric or NULL}

\item{\code{AIC}}{A numeric or NULL}

\item{\code{BIC}}{A numeric or NULL}

\item{\code{mcmc_results}}{A data.frame containing the estimated parameters for each iteration of the
MCMC sampling procedure}
}}

\section{Main results}{

The main results are accessed with the \code{results()} method.
They are given in the form of a data frame with the following columns;
\itemize{
\item \code{est}: value of the estimated parameter
\item \code{sd}: value of the standard deviation of the parameter
\item \code{t.test}: value of the t-statistic under the two-sided hypothesis that
the parameter value is 0.
\item \code{p.val}: the p-value associated to the t-test
\item \code{quant_025}: for Bayesian estimation the lower bound of 95\% interval
\item \code{quant_975}: for Bayesian estimation the upper bound of 95\% interval
}
}

\examples{

spflow_results <- spflow(y9 ~ . + G_(DISTANCE),multi_net_usa_ge)

# General methods
results(spflow_results) # data.frame of main results
coef(spflow_results) # vector of estimated coefficients
fitted(spflow_results) # vector of fitted values
resid(spflow_results) # vector of residuals
nobs(spflow_results) # number of observations
sd_error(spflow_results) # standard deviation of the error term
predict(spflow_results) # computation of the in sample predictor

# MLE methods
logLik(spflow_results) # value of the likelihood function

# MLE, OLS and S2SLS methods
varcov(spflow_results) # variance covariance matrix of the estimators

# MCMC methods
spflow_results_mcmc <- spflow(
  y2 ~ . + G_(DISTANCE),
  multi_net_usa_ge,
  flow_control = spflow_control(estimation_method = "mcmc",
                                model = "model_2"))
results(spflow_results)
mcmc_results(spflow_results_mcmc) # parameter values during the mcmc sampling

}
\seealso{
\code{\link[=spflow]{spflow()}}, \code{\link[=spflow_network_classes]{spflow_network_classes()}}
}
