% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\docType{data}
\name{example_data}
\alias{example_data}
\alias{multi_net_usa_ge}
\alias{germany_grid}
\alias{usa_net}
\alias{usa_grid}
\alias{germany_net}
\alias{simulation_params}
\title{Simulated data for stylized versions of Germany and the USA}
\format{
An object of class \code{sp_multi_network} of length 1.

An object of class \code{sf} (inherits from \code{data.frame}) with 16 rows and 3 columns.

An object of class \code{sp_network_nodes} of length 1.

An object of class \code{sf} (inherits from \code{data.frame}) with 51 rows and 3 columns.

An object of class \code{sp_network_nodes} of length 1.

An object of class \code{list} of length 3.
}
\source{
Simulated data inspired by
https://ialab.it.monash.edu/~dwyer/papers/maptrix.pdf
}
\usage{
multi_net_usa_ge

germany_grid

usa_net

usa_grid

germany_net

simulation_params
}
\description{
The package uses the same stylized country examples as those presented by
\insertCite{Yang2017;textual}{spflow}.
The first example is a stylized version of Germany with 16 states.
The second example is a stylized version of the USA with 51 states.

We provide spatial objects that contain the geography of our example,
as well as two \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}} objects.
Finally, there is an \code{\link[=sp_multi_network-class]{sp_multi_network-class()}} containing the two networks
and four network pair objects based on the same example.

The simulation parameters are given as \code{rho} for the auto-regressive
parameter, \code{delta} for the impact of the exogenous variables and \code{sd_error}
for standard deviation of the simulated Gaussian noise.
They are used to simulate two flow vectors \code{y2} and \code{y9} for each network
pair inside the \code{multi_net_usa_ge}.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
