% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vp.R
\name{vp}
\alias{vp}
\title{Variance Partitioning with Moran Spectral Randomization}
\usage{
vp(y, x = NULL, evecs = NULL, msr = 100)
}
\arguments{
\item{y}{outcome vector}

\item{x}{vector/ matrix of covariates}

\item{evecs}{selected eigenvectors}

\item{msr}{number of permutations to compute the expected value under H0}
}
\value{
Returns an object of class \code{vpart} which provides the following
information:
\describe{
\item{\code{R2}}{unadjusted fractions of explained variation}
\item{\code{adjR2}}{adjusted fractions (based on Moran spectral randomization)}
\item{\code{msr}}{number of permutations to obtain the expected value under H0}
}
}
\description{
This function decomposes the variation in an outcome variable
into four fractions: a) the influence of covariates, b) joint influence of
covariates and space, c) the influence of space, and d) unexplained residual
variation. Moran spectral randomization is applied to obtain the expected
value of the coefficient of determination adjusted for spurious correlations.
}
\note{
The adjusted R-squared values are obtained by: 1-(1-R2)/(1-E(R2|H0)).
For fractions [ab] and [a], Moran spectral randomization is used to derive
E(R2|H0). To this end, the rows in matrix (or column vector) x are randomly
permuted in order to preserve the correlation structure (see e.g., Clappe et
al. 2018).
}
\examples{
data(fakedata)
E <- getEVs(W=W,covars=NULL)$vectors

(partition <- vp(y=fakedataset$x1,evecs=E[,1:10],msr=100))

}
\references{
Clappe, Sylvie, Dray Stéphane. and Pedro R. Peres-Neto (2018):
Beyond neutrality: disentangling the effects of species sorting
and spurious correlations in community analysis. Ecology 99 (8):
pp. 1737 - 1747.

Wagner, Helene H., and Stéphane Dray (2015): Generating spatially
constrained null models for irregularly spaced data using Moran spectral
randomization methods. Methods in Ecology and Evolution 6 (10):
pp. 1169 - 1178.
}
\seealso{
\code{\link{getEVs}}
}
\author{
Sebastian Juhl
}
