% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_misc.R
\name{add.distance}
\alias{add.distance}
\alias{add.distance.resampling}
\alias{add.distance.represampling}
\title{Add distance information to resampling objects}
\usage{
add.distance(object, ...)

\method{add.distance}{resampling}(object, data, coords = c("x", "y"), ...)

\method{add.distance}{represampling}(object, data, coords = c("x", "y"), mode = "future", ...)
}
\arguments{
\item{object}{\link{resampling} or \link{represampling} object.}

\item{...}{Additional arguments to \link{dataset_distance} and
\link{add.distance.resampling}, respectively.}

\item{data}{\code{data.frame} containing at least the columns specified by
\code{coords}}

\item{coords}{(ignored by \code{partition_cv})}

\item{mode}{Use \code{future.apply::future_lapply()} for parallelized
execution if \code{mode = "future"}, and \code{lapply} for sequential
execution otherwise (\code{mode = "sequential"})}
}
\value{
A \link{resampling} or \link{represampling} object containing an additional.
\verb{$distance} component in each \link{resampling} object. The \code{distance} component
is a single numeric value indicating, for each \code{train} / \code{test} pair, the
(by default, mean) nearest-neighbour distance between the two sets.
}
\description{
Add distance information to resampling objects
}
\details{
Nearest-neighbour distances are calculated for each sample in the
test set. These \verb{nrow(???$test)} nearest-neighbour distances are then
averaged. Aggregation methods other than \code{mean} can be chosen using the
\code{fun} argument, which will be passed on to \link{dataset_distance}.
}
\examples{
# Muenchow et al. (2012), see ?ecuador
nsp.parti <- partition_cv(ecuador)
sp.parti <- partition_kmeans(ecuador)
nsp.parti <- add.distance(nsp.parti, data = ecuador)
sp.parti <- add.distance(sp.parti, data = ecuador)
# non-spatial partioning: very small test-training distance:
nsp.parti[[1]][[1]]$distance
# spatial partitioning: more substantial distance, depending on number of
# folds etc.
sp.parti[[1]][[1]]$distance
}
\seealso{
\link{dataset_distance} \link{represampling}
\link{resampling}
}
