\name{represampling.disc.bootstrap}
\alias{represampling.disc.bootstrap}
\title{Overlapping spatial block bootstrap using circular blocks}
\usage{
  represampling.disc.bootstrap(data, coords = c("x", "y"),
    nboot, repetition = 1, seed1 = NULL, oob = FALSE, ...)
}
\arguments{
  \item{oob}{logical (default \code{FALSE}): if
  \code{TRUE}, use the out-of-bag sample as the test sample
  (the complement of the \code{nboot[1]} test set discs,
  minus the buffer area as specified in the \code{...}
  arguments to \code{\link{partition.disc}}); if
  \code{FALSE}, draw a second bootstrap sample of size
  \code{nboot} independently to obtain a test sample (sets
  of overlapping discs drawn with replacement)}

  \item{nboot}{number of bootstrap samples; you may specify
  different values for the training sample
  (\code{nboot[1]}) and for the test sample
  (\code{nboot[2]})}

  \item{...}{additional arguments to be passed to
  \code{\link{partition.disc}}; note that a \code{buffer}
  argument has not effect if \code{oob=FALSE}; see example
  below}

  \item{data}{\code{data.frame} containing at least the
  columns specified by \code{coords}}

  \item{coords}{vector of length 2 defining the variables
  in \code{data} that contain the x and y coordinates of
  sample locations}

  \item{repetition}{numeric vector: cross-validation
  repetitions to be generated. Note that this is not the
  number of repetitions, but the indices of these
  repetitions. E.g., use \code{repetition=c(1:100)} to
  obtain (the 'first') 100 repetitions, and
  \code{repetition=c(101:200)} to obtain a different set of
  100 repetitions.}

  \item{seed1}{\code{seed1+i} is the random seed that will
  be used by \code{\link{set.seed}} in repetition \code{i}
  (\code{i} in \code{repetition}) to initialize the random
  number generator before sampling from the data set.}
}
\description{
  \code{represampling.disc.bootstrap} performs a spatial
  block bootstrap by resampling at the level of rectangular
  partitions or 'tiles' generated by
  \code{partition.tiles}.
}
\note{
  Performs \code{nboot} out of \code{nrow(data)} resampling
  of circular discs. This is an \emph{overlapping} spatial
  block bootstrap where the blocks are circular.
}
\examples{
data(ecuador)
# Overlapping disc bootstrap:
parti = represampling.disc.bootstrap(ecuador, radius=200, nboot=20, oob=FALSE)
plot(parti,ecuador)
# Note that a 'buffer' argument would make no difference because boostrap sets of discs are
# drawn independently for the training and test sample.
#
# Overlapping disc bootstrap for training sample, out-of-bag sample as test sample:
parti = represampling.disc.bootstrap(ecuador, radius=200, buffer=200, nboot=10, oob=TRUE)
plot(parti,ecuador)
}

