/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.MinimizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.util.DockUtilities;

public class FlapDockStationHandle
implements MinimizedModeArea {
    private String id;
    private FlapDockStation station;

    public FlapDockStationHandle(String id, FlapDockStation station) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.id = id;
        this.station = station;
    }

    public boolean autoDefaultArea() {
        return true;
    }

    public void addModeAreaListener(ModeAreaListener listener) {
    }

    public void removeModeAreaListener(ModeAreaListener listener) {
    }

    public void setController(DockController controller) {
    }

    public void setMode(LocationMode mode) {
    }

    public FlapDockStation getStation() {
        return this.station;
    }

    public DockableProperty getLocation(Dockable child) {
        return DockUtilities.getPropertyChain((DockStation)this.station, (Dockable)child);
    }

    public String getUniqueId() {
        return this.id;
    }

    public boolean isChild(Dockable dockable) {
        return dockable.getDockParent() == this.station;
    }

    public boolean respectWorkingAreas() {
        return false;
    }

    public void setLocation(Dockable dockable, DockableProperty location, AffectedSet set) {
        set.add(dockable);
        if (this.isChild(dockable)) {
            if (location != null) {
                this.station.move(dockable, location);
            }
        } else {
            if (location != null && !this.station.drop(dockable, location)) {
                location = null;
            }
            if (location == null) {
                this.station.drop(dockable);
            }
        }
    }
}

