/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.font;

import bibliothek.gui.dock.util.font.FontModifier;
import java.awt.Font;

public class GenericFontModifier
implements FontModifier {
    private Modify italic = Modify.IGNORE;
    private Modify bold = Modify.IGNORE;
    private boolean sizeDelta = true;
    private int size = 0;

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSizeDelta(boolean sizeDelta) {
        this.sizeDelta = sizeDelta;
    }

    public boolean isSizeDelta() {
        return this.sizeDelta;
    }

    public void setItalic(Modify italic) {
        this.italic = italic;
    }

    public Modify getItalic() {
        return this.italic;
    }

    public void setBold(Modify bold) {
        this.bold = bold;
    }

    public Modify getBold() {
        return this.bold;
    }

    public Font modify(Font font) {
        int flags = 0;
        if (font.isBold()) {
            flags |= 1;
        }
        if (font.isItalic()) {
            flags |= 2;
        }
        int newFlags = this.modify(flags, 2, this.italic);
        newFlags = this.modify(newFlags, 1, this.bold);
        float size = this.size;
        if (this.sizeDelta) {
            size += (float)font.getSize();
        }
        return font.deriveFont(newFlags, size);
    }

    private int modify(int flags, int flag, Modify modification) {
        switch (modification) {
            case IGNORE: {
                return flags;
            }
            case ON: {
                return flags | flag;
            }
            case OFF: {
                return flags & ~flag;
            }
            case REVERSE: {
                return flags ^ flag;
            }
        }
        return flags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modify {
        ON,
        OFF,
        REVERSE,
        IGNORE;

    }
}

