/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFullScreenAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    private SplitDockStation split;
    private DockController controller;
    private DockActionIcon iconNormalize;
    private DockActionIcon iconMaximize;
    private DockActionText textNormalize;
    private DockActionText textMaximize;
    private DockActionText textNormalizeTooltip;
    private DockActionText textMaximizeTooltip;
    private PropertyValue<KeyStroke> accelerator = new PropertyValue<KeyStroke>(SplitDockStation.MAXIMIZE_ACCELERATOR){

        @Override
        protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
            SplitFullScreenAction.this.setAccelerator(Boolean.TRUE, newValue);
            SplitFullScreenAction.this.setAccelerator(Boolean.FALSE, newValue);
        }
    };

    public SplitFullScreenAction(SplitDockStation station) {
        super(null);
        this.split = station;
        this.setRemoveEmptyGroups(false);
        station.addSplitDockStationListener(new SplitDockListener(){

            public void fullScreenDockableChanged(SplitDockStation station, Dockable oldFullScreen, Dockable newFullScreen) {
                if (oldFullScreen != null) {
                    SplitFullScreenAction.this.change(oldFullScreen, Boolean.FALSE);
                }
                if (newFullScreen != null) {
                    SplitFullScreenAction.this.change(newFullScreen, Boolean.TRUE);
                }
            }
        });
        this.textNormalize = new DockActionText("split.normalize", this){

            protected void changed(String oldValue, String newValue) {
                SplitFullScreenAction.this.setText(Boolean.TRUE, newValue);
            }
        };
        this.textMaximize = new DockActionText("split.maximize", this){

            protected void changed(String oldValue, String newValue) {
                SplitFullScreenAction.this.setText(Boolean.FALSE, newValue);
            }
        };
        this.textNormalizeTooltip = new DockActionText("split.normalize.tooltip", this){

            protected void changed(String oldValue, String newValue) {
                SplitFullScreenAction.this.setTooltip(Boolean.TRUE, newValue);
            }
        };
        this.textMaximizeTooltip = new DockActionText("split.maximize.tooltip", this){

            protected void changed(String oldValue, String newValue) {
                SplitFullScreenAction.this.setTooltip(Boolean.FALSE, newValue);
            }
        };
        this.iconNormalize = new DockActionIcon("split.normalize", this){

            protected void changed(Icon oldValue, Icon newValue) {
                SplitFullScreenAction.this.setIcon(Boolean.TRUE, newValue);
            }
        };
        this.iconMaximize = new DockActionIcon("split.maximize", this){

            protected void changed(Icon oldValue, Icon newValue) {
                SplitFullScreenAction.this.setIcon(Boolean.FALSE, newValue);
            }
        };
    }

    @Override
    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            this.accelerator.setProperties(controller);
            if (controller == null) {
                this.iconNormalize.setManager(null);
                this.iconMaximize.setManager(null);
                this.textNormalize.setManager(null);
                this.textMaximize.setManager(null);
                this.textNormalizeTooltip.setManager(null);
                this.textMaximizeTooltip.setManager(null);
            } else {
                this.iconNormalize.setManager(controller.getIcons());
                this.iconMaximize.setManager(controller.getIcons());
                this.textNormalize.setManager(controller.getTexts());
                this.textMaximize.setManager(controller.getTexts());
                this.textNormalizeTooltip.setManager(controller.getTexts());
                this.textMaximizeTooltip.setManager(controller.getTexts());
            }
        }
    }

    @Override
    public void action(Dockable dockable) {
        while (dockable.getDockParent() != this.split) {
            DockStation station = dockable.getDockParent();
            if (station == null) {
                return;
            }
            dockable = station.asDockable();
            if (dockable != null) continue;
            return;
        }
        Dockable fullscreen = this.split.getFullScreen();
        if (fullscreen == dockable) {
            this.split.setFullScreen(null);
        } else {
            this.split.setFullScreen(dockable);
        }
    }

    private void change(Dockable dockable, Boolean value) {
        DockStation station;
        if (this.isKnown(dockable)) {
            this.setGroup(value, dockable);
        }
        if ((station = dockable.asDockStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.change(station.getDockable(i), value);
            }
        }
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        while (dockable.getDockParent() != this.split) {
            DockStation station = dockable.getDockParent();
            if (station == null) {
                return Boolean.FALSE;
            }
            dockable = station.asDockable();
            if (dockable != null) continue;
            return Boolean.FALSE;
        }
        if (dockable == this.split.getFullScreen()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

