/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.focus;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.focus.AbstractDockableSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultDockableSelection
extends AbstractDockableSelection {
    private Model model = new Model();
    private JScrollPane listPane;
    private JList list = new JList(this.model);

    public DefaultDockableSelection() {
        this.list.setCellRenderer(new Renderer());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DefaultDockableSelection.this.setSelection((Dockable)DefaultDockableSelection.this.list.getSelectedValue());
            }
        });
        this.setLayout(new BorderLayout());
        this.listPane = new JScrollPane(this.list);
        this.add((Component)this.listPane, "Center");
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DefaultDockableSelection.this.select();
            }
        });
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int current = DefaultDockableSelection.this.list.getSelectedIndex();
                int index = DefaultDockableSelection.this.list.locationToIndex(e.getPoint());
                if (index != current && index >= 0 && index < DefaultDockableSelection.this.model.getSize()) {
                    DefaultDockableSelection.this.list.setSelectedIndex(index);
                }
            }
        });
    }

    public void updateUI() {
        super.updateUI();
        if (this.list != null) {
            this.list.setCellRenderer(new Renderer());
        }
    }

    protected JComponent getList() {
        return this.listPane;
    }

    protected void up() {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            index = 0;
        } else if (--index < 0) {
            index = this.model.getSize() - 1;
        }
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    protected void right() {
        this.down();
    }

    protected void down() {
        int index = this.list.getSelectedIndex();
        if (++index >= this.model.getSize()) {
            index = 0;
        }
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    protected void left() {
        this.up();
    }

    protected void iconChanged(int index, Dockable dockable) {
        this.model.change(index);
    }

    protected void insert(int index, Dockable dockable) {
        this.model.insertElementAt(dockable, index);
    }

    protected void remove(int index, Dockable dockable) {
        this.model.remove(index);
    }

    protected void select(Dockable dockable) {
        this.list.setSelectedValue(dockable, true);
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            this.list.ensureIndexIsVisible(index);
        }
    }

    protected void titleChanged(int index, Dockable dockable) {
        this.model.change(index);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Dockable) {
                Dockable dockable = (Dockable)value;
                super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
                this.setText(dockable.getTitleText());
                this.setIcon(dockable.getTitleIcon());
                return this;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class Model
    extends DefaultListModel {
        private Model() {
        }

        public void change(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }
}

