/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.KeyboardController;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.event.LocatedListenerList;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractKeyboardController
implements KeyboardController {
    private LocatedListenerList<KeyboardListener> keyListeners = new LocatedListenerList();
    private List<KeyListener> globalListeners = new ArrayList<KeyListener>();
    private DockController controller;

    public AbstractKeyboardController(DockController controller) {
        this.controller = controller;
    }

    public void addGlobalListener(KeyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.globalListeners.add(listener);
    }

    public void removeGlobalListener(KeyListener listener) {
        this.globalListeners.remove(listener);
    }

    public void addListener(KeyboardListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.keyListeners.addListener(listener);
    }

    public void removeListener(KeyboardListener listener) {
        this.keyListeners.removeListener(listener);
    }

    public DockController getController() {
        return this.controller;
    }

    protected void fireKeyPressed(KeyEvent event) {
        DockElementRepresentative representative;
        if (!event.isConsumed() && (representative = this.controller.searchElement(event.getComponent())) != null) {
            DockElement element = representative.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(element);
            for (KeyboardListener listener : list) {
                if (!listener.keyPressed(element, event)) continue;
                event.consume();
                break;
            }
        }
        for (KeyListener listener : this.globalListeners.toArray(new KeyListener[this.globalListeners.size()])) {
            listener.keyPressed(event);
        }
    }

    protected void fireKeyReleased(KeyEvent event) {
        DockElementRepresentative representative;
        if (!event.isConsumed() && (representative = this.controller.searchElement(event.getComponent())) != null) {
            DockElement element = representative.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(element);
            for (KeyboardListener listener : list) {
                if (!listener.keyReleased(element, event)) continue;
                event.consume();
                break;
            }
        }
        for (KeyListener listener : this.globalListeners.toArray(new KeyListener[this.globalListeners.size()])) {
            listener.keyReleased(event);
        }
    }

    protected void fireKeyTyped(KeyEvent event) {
        DockElementRepresentative representative;
        if (!event.isConsumed() && (representative = this.controller.searchElement(event.getComponent())) != null) {
            DockElement element = representative.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(element);
            for (KeyboardListener listener : list) {
                if (!listener.keyTyped(element, event)) continue;
                event.consume();
                break;
            }
        }
        for (KeyListener listener : this.globalListeners.toArray(new KeyListener[this.globalListeners.size()])) {
            listener.keyTyped(event);
        }
    }
}

