/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.intern.color.MinimizedButtonColorTransmitter;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;

public class BubbleButtonTitleTransmitter
extends MinimizedButtonColorTransmitter {
    private static final String[] KEYS = new String[]{"title.background.top.active.mouse.flap", "title.background.top.active.flap", "title.background.top.inactive.mouse.flap", "title.background.top.inactive.flap", "title.background.top.selected.mouse.flap", "title.background.top.selected.flap", "title.background.bottom.active.mouse.flap", "title.background.bottom.active.flap", "title.background.bottom.inactive.mouse.flap", "title.background.bottom.inactive.flap", "title.background.bottom.selected.mouse.flap", "title.background.bottom.selected.flap", "title.foreground.active.mouse.flap", "title.foreground.active.flap", "title.foreground.inactive.mouse.flap", "title.foreground.inactive.flap", "title.foreground.selected.mouse.flap", "title.foreground.selected.flap"};

    public BubbleButtonTitleTransmitter(ColorManager manager) {
        super(manager, KEYS);
    }

    protected Color convert(Color source, String key) {
        if (this.isFocused(key)) {
            return this.convertFocused(Colors.diffMirror(source, 0.2), key);
        }
        if (this.isSelected(key)) {
            return this.convertSelected(Colors.diffMirror(source, 0.2), key);
        }
        if (key.contains("foreground")) {
            return Colors.diffMirror(source, 1.0);
        }
        if ("title.background.top.inactive.flap".equals(key)) {
            return Colors.darker(source, 0.3);
        }
        if ("title.background.bottom.inactive.flap".equals(key)) {
            return Colors.brighter(source, 0.3);
        }
        if ("title.background.top.inactive.mouse.flap".equals(key)) {
            return Colors.fuller(Colors.darker(source, 0.3), 0.3);
        }
        if ("title.background.bottom.inactive.mouse.flap".equals(key)) {
            return Colors.fuller(Colors.brighter(source, 0.3), 0.3);
        }
        return source;
    }

    protected Color convertFocused(Color source, String key) {
        if (key.contains("foreground")) {
            return Colors.diffMirror(source, 1.0);
        }
        if ("title.background.top.active.flap".equals(key)) {
            return Colors.darker(source, 0.3);
        }
        if ("title.background.bottom.active.flap".equals(key)) {
            return Colors.brighter(source, 0.3);
        }
        if ("title.background.top.active.mouse.flap".equals(key)) {
            return Colors.fuller(Colors.darker(source, 0.3), 0.3);
        }
        if ("title.background.bottom.active.mouse.flap".equals(key)) {
            return Colors.fuller(Colors.brighter(source, 0.3), 0.3);
        }
        return source;
    }

    protected Color convertSelected(Color source, String key) {
        if (key.contains("foreground")) {
            return Colors.diffMirror(source, 1.0);
        }
        if ("title.background.top.selected.flap".equals(key)) {
            return Colors.darker(source, 0.3);
        }
        if ("title.background.bottom.selected.flap".equals(key)) {
            return Colors.brighter(source, 0.3);
        }
        if ("title.background.top.selected.mouse.flap".equals(key)) {
            return Colors.fuller(Colors.darker(source, 0.3), 0.3);
        }
        if ("title.background.bottom.selected.mouse.flap".equals(key)) {
            return Colors.fuller(Colors.brighter(source, 0.3), 0.3);
        }
        return source;
    }

    protected boolean isFocused(String id) {
        return id.contains("active") && !id.contains("inactive");
    }

    protected boolean isForeground(String id) {
        return id.contains("foreground");
    }

    protected boolean isSelected(String id) {
        return id.contains("selected");
    }
}

