/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.intern.AbstractCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.station.FlapResizeRequestHandler;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CMinimizedLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.station.CFlapDockStationHandle;
import bibliothek.gui.dock.common.mode.station.CSplitDockStationHandle;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CMinimizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CContentArea
extends JPanel {
    private SplitDockStation center;
    private FlapDockStation north;
    private FlapDockStation south;
    private FlapDockStation east;
    private FlapDockStation west;
    private JComponent northComponent;
    private JComponent southComponent;
    private JComponent eastComponent;
    private JComponent westComponent;
    private Component[] cornerComponents = new Component[8];
    private String uniqueId;
    private CControl control;
    private CStation<?>[] stations;

    public CContentArea(CControl control, String uniqueId) {
        this.control = control;
        this.uniqueId = uniqueId;
        this.center = control.getFactory().createSplitDockStation();
        this.center.setExpandOnDoubleclick(false);
        this.northComponent = new JPanel(new BorderLayout());
        this.southComponent = new JPanel(new BorderLayout());
        this.eastComponent = new JPanel(new BorderLayout());
        this.westComponent = new JPanel(new BorderLayout());
        this.north = control.getFactory().createFlapDockStation(this.northComponent);
        this.south = control.getFactory().createFlapDockStation(this.southComponent);
        this.east = control.getFactory().createFlapDockStation(this.eastComponent);
        this.west = control.getFactory().createFlapDockStation(this.westComponent);
        this.north.setAutoDirection(false);
        this.north.setDirection(FlapDockStation.Direction.SOUTH);
        this.south.setAutoDirection(false);
        this.south.setDirection(FlapDockStation.Direction.NORTH);
        this.east.setAutoDirection(false);
        this.east.setDirection(FlapDockStation.Direction.WEST);
        this.west.setAutoDirection(false);
        this.west.setDirection(FlapDockStation.Direction.EAST);
        this.setLayout(new BorderLayout());
        this.northComponent.add(this.north.getComponent(), "Center");
        this.southComponent.add(this.south.getComponent(), "Center");
        this.eastComponent.add(this.east.getComponent(), "Center");
        this.westComponent.add(this.west.getComponent(), "Center");
        this.add((Component)this.center, "Center");
        this.add((Component)this.northComponent, "North");
        this.add((Component)this.southComponent, "South");
        this.add((Component)this.eastComponent, "East");
        this.add((Component)this.westComponent, "West");
        CBaseLocation base = new CBaseLocation(this);
        this.stations = new CStation[]{new CenterStation(this.center, this.getCenterIdentifier(), base.normal()), new MinimizeStation(this.north, this.getNorthIdentifier(), (CLocation)new CMinimizedLocation(base, Side.NORTH)), new MinimizeStation(this.south, this.getSouthIdentifier(), (CLocation)new CMinimizedLocation(base, Side.SOUTH)), new MinimizeStation(this.east, this.getEastIdentifier(), (CLocation)new CMinimizedLocation(base, Side.EAST)), new MinimizeStation(this.west, this.getWestIdentifier(), (CLocation)new CMinimizedLocation(base, Side.WEST))};
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public CControl getControl() {
        return this.control;
    }

    public CStation<?>[] getStations() {
        CStation[] copy = new CStation[this.stations.length];
        System.arraycopy(this.stations, 0, copy, 0, this.stations.length);
        return copy;
    }

    public void deploy(CGrid grid) {
        this.getCenter().dropTree(grid.toTree());
    }

    public void setCornerComponent(Component component, Corner corner, boolean horizontal) {
        int index = corner.ordinal() * 2;
        if (horizontal) {
            ++index;
        }
        if (this.cornerComponents[index] != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (horizontal) {
                        this.northComponent.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.westComponent.remove(this.cornerComponents[index]);
                    break;
                }
                case NORTH_EAST: {
                    if (horizontal) {
                        this.northComponent.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.eastComponent.remove(this.cornerComponents[index]);
                    break;
                }
                case SOUTH_WEST: {
                    if (horizontal) {
                        this.southComponent.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.westComponent.remove(this.cornerComponents[index]);
                    break;
                }
                case SOUTH_EAST: {
                    if (horizontal) {
                        this.southComponent.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.eastComponent.remove(this.cornerComponents[index]);
                }
            }
        }
        this.cornerComponents[index] = component;
        if (component != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (horizontal) {
                        this.northComponent.add(component, "West");
                        break;
                    }
                    this.westComponent.add(component, "North");
                    break;
                }
                case NORTH_EAST: {
                    if (horizontal) {
                        this.northComponent.add(component, "East");
                        break;
                    }
                    this.eastComponent.add(component, "North");
                    break;
                }
                case SOUTH_WEST: {
                    if (horizontal) {
                        this.southComponent.add(component, "West");
                        break;
                    }
                    this.westComponent.add(component, "South");
                    break;
                }
                case SOUTH_EAST: {
                    if (horizontal) {
                        this.southComponent.add(component, "East");
                        break;
                    }
                    this.eastComponent.add(component, "South");
                }
            }
        }
    }

    public Component getCornerComponent(Corner corner, boolean horizontal) {
        int index = corner.ordinal() * 2;
        if (horizontal) {
            ++index;
        }
        return this.cornerComponents[index];
    }

    public void setMinimumAreaSize(Dimension size) {
        this.north.setMinimumSize(size);
        this.south.setMinimumSize(size);
        this.west.setMinimumSize(size);
        this.east.setMinimumSize(size);
    }

    public SplitDockStation getCenter() {
        return this.center;
    }

    public FlapDockStation getNorth() {
        return this.north;
    }

    public FlapDockStation getSouth() {
        return this.south;
    }

    public FlapDockStation getEast() {
        return this.east;
    }

    public FlapDockStation getWest() {
        return this.west;
    }

    public String getCenterIdentifier() {
        return CContentArea.getCenterIdentifier(this.uniqueId);
    }

    public static String getCenterIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " center";
    }

    public String getNorthIdentifier() {
        return CContentArea.getNorthIdentifier(this.uniqueId);
    }

    public static String getNorthIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " north";
    }

    public String getSouthIdentifier() {
        return CContentArea.getSouthIdentifier(this.uniqueId);
    }

    public static String getSouthIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " south";
    }

    public String getEastIdentifier() {
        return CContentArea.getEastIdentifier(this.uniqueId);
    }

    public static String getEastIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " east";
    }

    public String getWestIdentifier() {
        return CContentArea.getWestIdentifier(this.uniqueId);
    }

    public static String getWestIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " west";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CenterStation
    extends AbstractCStation<SplitDockStation> {
        private ResizeRequestListener handler;
        private CSplitDockStationHandle modeManagerHandle;

        public CenterStation(SplitDockStation station, String id, CLocation location) {
            super(station, id, location);
            this.handler = new SplitResizeRequestHandler(station);
            this.modeManagerHandle = new CSplitDockStationHandle(this, CContentArea.this.control.getLocationManager());
        }

        @Override
        protected void install(CControlAccess access) {
            access.getOwner().addResizeRequestListener(this.handler);
            CLocationModeManager manager = access.getLocationManager();
            manager.getNormalMode().add(this.modeManagerHandle.asNormalModeArea());
            manager.getMaximizedMode().add(this.modeManagerHandle.asMaximziedModeArea());
        }

        @Override
        protected void uninstall(CControlAccess access) {
            access.getOwner().removeResizeRequestListener(this.handler);
            CLocationModeManager manager = access.getLocationManager();
            manager.getNormalMode().remove(this.modeManagerHandle.asNormalModeArea().getUniqueId());
            manager.getMaximizedMode().remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
        }

        @Override
        public CStationPerspective createPerspective() {
            return new CGridPerspective(this.getUniqueId(), this.isWorkingArea());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinimizeStation
    extends AbstractCStation<FlapDockStation> {
        private ResizeRequestListener handler;
        private CFlapDockStationHandle modeManagerHandle;

        public MinimizeStation(FlapDockStation station, String id, CLocation location) {
            super(station, id, location);
            this.handler = new FlapResizeRequestHandler(station);
            this.modeManagerHandle = new CFlapDockStationHandle(this);
        }

        @Override
        protected void install(CControlAccess access) {
            access.getOwner().addResizeRequestListener(this.handler);
            access.getLocationManager().getMinimizedMode().add(this.modeManagerHandle);
        }

        @Override
        protected void uninstall(CControlAccess access) {
            access.getOwner().removeResizeRequestListener(this.handler);
            access.getLocationManager().getMinimizedMode().remove(this.modeManagerHandle.getUniqueId());
        }

        @Override
        public CStationPerspective createPerspective() {
            return new CMinimizePerspective(this.getUniqueId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Corner {
        SOUTH_EAST,
        SOUTH_WEST,
        NORTH_EAST,
        NORTH_WEST;

    }
}

