/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.themes.color.MenuColor;
import bibliothek.gui.dock.util.BackgroundPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubbleTabMenu
extends AbstractCombinedMenu {
    private StackDockComponentParent station;
    private BubbleMenuColor colorTopMouse;
    private BubbleMenuColor colorBottomMouse;
    private BubbleMenuColor colorBorderMouse;
    private BubbleMenuColor colorTop;
    private BubbleMenuColor colorBottom;
    private BubbleMenuColor colorBorder;
    private BubbleColorAnimation animation;
    private boolean mouseOver;
    private int borderSize = 3;

    public BubbleTabMenu(StackDockComponentParent station, TabPane parent, CombinedHandler<CombinedMenu> visibility) {
        super(parent, visibility);
        this.station = station;
        this.colorTopMouse = new BubbleMenuColor("stack.menu.background.top.mouse", Color.RED.brighter());
        this.colorBottomMouse = new BubbleMenuColor("stack.menu.background.bottom.mouse", Color.RED.darker());
        this.colorBorderMouse = new BubbleMenuColor("stack.menu.border.mouse", Color.RED.darker().darker());
        this.colorTop = new BubbleMenuColor("stack.menu.background.top", Color.RED.brighter());
        this.colorBottom = new BubbleMenuColor("stack.menu.background.bottom", Color.RED.darker());
        this.colorBorder = new BubbleMenuColor("stack.menu.border", Color.RED.darker().darker());
        this.animation = new BubbleColorAnimation();
        this.animate();
        this.animation.kick();
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        this.colorTopMouse.connect(controller);
        this.colorBottomMouse.connect(controller);
        this.colorBorderMouse.connect(controller);
        this.colorTop.connect(controller);
        this.colorBottom.connect(controller);
        this.colorBorder.connect(controller);
        this.animate();
        this.animation.kick();
    }

    public void stopAnimation() {
        this.animation.stop();
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    private void animate() {
        if (this.isMouseOver()) {
            this.animation.putColor("top", this.colorTopMouse.color());
            this.animation.putColor("bottom", this.colorBottomMouse.color());
            this.animation.putColor("border", this.colorBorderMouse.color());
        } else {
            this.animation.putColor("top", this.colorTop.color());
            this.animation.putColor("bottom", this.colorBottom.color());
            this.animation.putColor("border", this.colorBorder.color());
        }
    }

    @Override
    protected Component createComponent() {
        return new Button();
    }

    @Override
    protected void selected(Dockable dockable) {
    }

    protected class BubbleMenuColor
    extends MenuColor {
        public BubbleMenuColor(String id, Color backup) {
            super(id, BubbleTabMenu.this.station.getStackDockParent(), BubbleTabMenu.this, backup);
        }

        protected void changed(Color oldValue, Color newValue) {
            BubbleTabMenu.this.animate();
        }
    }

    private class Button
    extends BackgroundPanel
    implements Runnable {
        public Button() {
            super(false, false);
            this.setOpaque(false);
            this.setBackground(BubbleTabMenu.this.getBackground());
            BubbleTabMenu.this.animation.addTask(this);
            this.setPreferredSize(new Dimension(20, 20));
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    BubbleTabMenu.this.mouseOver = true;
                    BubbleTabMenu.this.animate();
                }

                public void mouseExited(MouseEvent e) {
                    BubbleTabMenu.this.mouseOver = false;
                    BubbleTabMenu.this.animate();
                }

                public void mouseClicked(MouseEvent e) {
                    BubbleTabMenu.this.open();
                }
            });
        }

        public void run() {
            this.repaint();
        }

        public void paintBackground(Graphics g) {
            Color top = BubbleTabMenu.this.animation.getColor("top");
            Color bottom = BubbleTabMenu.this.animation.getColor("bottom");
            Color border = BubbleTabMenu.this.animation.getColor("border");
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(border);
            g2.fillOval(0, 0, w, h);
            if (w > 2 * BubbleTabMenu.this.borderSize && h > 2 * BubbleTabMenu.this.borderSize) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, 0.0f, h - BubbleTabMenu.this.borderSize, bottom));
                g2.fillOval(BubbleTabMenu.this.borderSize, BubbleTabMenu.this.borderSize, w - 2 * BubbleTabMenu.this.borderSize, h - 2 * BubbleTabMenu.this.borderSize);
            }
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, h / 2, Color.WHITE));
            g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
            g2.fillArc(0, 0, w, h, 0, 180);
            g2.dispose();
        }
    }
}

