/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.util.SimpleDockElementRepresentative;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DefaultStackDockComponent
extends JTabbedPane
implements StackDockComponent {
    private List<Tab> dockables = new ArrayList<Tab>();
    private DockController controller;
    private Tab mouseTarget;

    public DefaultStackDockComponent() {
        super(3);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void setTabPlacement(TabPlacement tabPlacement) {
        switch (tabPlacement) {
            case BOTTOM_OF_DOCKABLE: {
                this.setTabPlacement(3);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.setTabPlacement(2);
                break;
            }
            case TOP_OF_DOCKABLE: {
                this.setTabPlacement(1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.setTabPlacement(4);
            }
        }
    }

    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        this.insertTab(string, icon, component, (String)null, n);
        Tab tab = this.createTab(dockable);
        this.dockables.add(n, tab);
        tab.setController(this.controller);
    }

    protected Tab createTab(Dockable dockable) {
        return new Tab(dockable);
    }

    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.addTab(string, icon, component);
        Tab tab = this.createTab(dockable);
        this.dockables.add(tab);
        tab.setController(this.controller);
    }

    public Dockable getDockableAt(int n) {
        return this.dockables.get(n).getDockable();
    }

    public void moveTab(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n2 < 0 || n2 >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.getSelectedIndex();
        String string = this.getTitleAt(n);
        String string2 = this.getToolTipTextAt(n);
        Icon icon = this.getIconAt(n);
        Component component = this.getComponentAt(n);
        Dockable dockable = this.dockables.get(n).getDockable();
        this.remove(n);
        this.insertTab(string, icon, component, dockable, n2);
        this.setTooltipAt(n2, string2);
        if (n3 == n) {
            n3 = n2;
        } else if (n3 > n && n3 <= n2) {
            ++n3;
        }
        this.setSelectedIndex(n3);
    }

    public void removeAll() {
        for (Tab tab : this.dockables) {
            tab.setController(null);
        }
        super.removeAll();
        this.dockables.clear();
    }

    public void remove(int n) {
        Tab tab = this.dockables.remove(n);
        tab.setController(null);
        super.remove(n);
    }

    public Component getComponent() {
        return this;
    }

    public void setTitleAt(int n, String string) {
        super.setTitleAt(n, string == null ? "" : string);
    }

    public void setTooltipAt(int n, String string) {
        this.setToolTipTextAt(n, string);
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.mouseTarget != null) {
                if (this.mouseTarget.relocator != null) {
                    this.mouseTarget.relocator.cancel();
                }
                this.mouseTarget = null;
            }
            this.controller = dockController;
            for (Tab tab : this.dockables) {
                tab.setController(dockController);
            }
        }
    }

    public boolean hasBorder() {
        return true;
    }

    public boolean isSingleTabComponent() {
        return false;
    }

    public DockElementRepresentative createDefaultRepresentation(DockElement dockElement) {
        return new SimpleDockElementRepresentative(dockElement, this);
    }

    private class Listener
    extends MouseInputAdapter {
        private Listener() {
        }

        private void updateRelocator(int n, int n2, boolean bl, boolean bl2) {
            boolean bl3;
            boolean bl4 = bl3 = DefaultStackDockComponent.this.controller == null || !DefaultStackDockComponent.this.controller.getRelocator().isDragOnlyTitel();
            if (DefaultStackDockComponent.this.mouseTarget != null) {
                if (!bl3) {
                    DefaultStackDockComponent.this.mouseTarget.relocator.cancel();
                    if (!bl2) {
                        DefaultStackDockComponent.this.mouseTarget = null;
                    }
                }
                return;
            }
            if (!bl3 && !bl2) {
                return;
            }
            if (bl) {
                int n3 = DefaultStackDockComponent.this.getTabCount();
                for (int i = 0; i < n3; ++i) {
                    Rectangle rectangle = DefaultStackDockComponent.this.getBoundsAt(i);
                    if (rectangle == null || !rectangle.contains(n, n2)) continue;
                    DefaultStackDockComponent.this.mouseTarget = (Tab)DefaultStackDockComponent.this.dockables.get(i);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), true, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.init(point.x, point.y, 0, 0, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            } else {
                this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), true, true);
                if (DefaultStackDockComponent.this.mouseTarget != null) {
                    DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                    DefaultStackDockComponent.this.mouseTarget = null;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), false, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.drop(point.x, point.y, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            } else {
                this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), true, true);
                if (DefaultStackDockComponent.this.mouseTarget != null) {
                    DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                    DefaultStackDockComponent.this.mouseTarget = null;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), false, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.drag(point.x, point.y, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            }
        }
    }

    protected class Tab
    extends ActionPopup {
        protected Dockable dockable;
        private RemoteRelocator relocator;

        public Tab(Dockable dockable) {
            super(true);
            this.dockable = dockable;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public void setController(DockController dockController) {
            this.relocator = dockController == null ? null : dockController.getRelocator().createRemote(this.dockable);
        }

        public void popup(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger()) {
                super.popup(mouseEvent);
            }
        }

        protected DockActionSource getSource() {
            return this.dockable.getGlobalActionOffers();
        }

        protected boolean isEnabled() {
            return true;
        }
    }
}

