/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedSelectableDockAction;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.util.IconManager;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockHoldToggle
extends GroupedSelectableDockAction.Check<Boolean>
implements ListeningDockAction {
    private FlapDockStation flap;
    private DockController controller;
    private Listener listener = new Listener();

    public FlapDockHoldToggle(FlapDockStation flapDockStation) {
        super(null);
        this.setRemoveEmptyGroups(false);
        this.flap = flapDockStation;
        flapDockStation.addFlapDockStationListener(new FlapDockListener(){

            public void holdChanged(FlapDockStation flapDockStation, Dockable dockable, boolean bl) {
                if (FlapDockHoldToggle.this.isBound(dockable)) {
                    FlapDockHoldToggle.this.setGroup(bl, dockable);
                }
            }
        });
        this.setSelected(Boolean.FALSE, false);
        this.setSelected(Boolean.TRUE, true);
        this.setText(Boolean.FALSE, DockUI.getDefaultDockUI().getString("flap.stick.false"));
        this.setText(Boolean.TRUE, DockUI.getDefaultDockUI().getString("flap.stick.true"));
        this.setTooltip(Boolean.FALSE, DockUI.getDefaultDockUI().getString("flap.stick.false.tooltip"));
        this.setTooltip(Boolean.TRUE, DockUI.getDefaultDockUI().getString("flap.stick.true.tooltip"));
    }

    @Override
    public boolean trigger(Dockable dockable) {
        this.setSelected(dockable, !this.isSelected(dockable));
        return true;
    }

    @Override
    public void setSelected(Dockable dockable, boolean bl) {
        this.flap.setHold(dockable, bl);
        this.setGroup(bl, dockable);
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        return this.flap.isHold(dockable);
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getIcons().remove("flap.hold", this.listener);
                this.controller.getIcons().remove("flap.free", this.listener);
            }
            this.controller = dockController;
            if (dockController != null) {
                IconManager iconManager = dockController.getIcons();
                iconManager.add("flap.hold", this.listener);
                iconManager.add("flap.free", this.listener);
                this.setIcon(false, iconManager.getIcon("flap.free"));
                this.setSelectedIcon(true, iconManager.getIcon("flap.hold"));
            }
        }
    }

    private class Listener
    implements IconManagerListener {
        private Listener() {
        }

        public void iconChanged(String string, Icon icon) {
            if (string.equals("flap.free")) {
                FlapDockHoldToggle.this.setIcon(false, icon);
            } else {
                FlapDockHoldToggle.this.setSelectedIcon(true, icon);
            }
        }
    }
}

