/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class PopupController
implements DockControllerRepresentativeListener {
    private Map<DockElementRepresentative, ComponentObserver> listeners = new HashMap<DockElementRepresentative, ComponentObserver>();
    private DockController controller;

    public PopupController(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
        dockController.addRepresentativeListener(this);
    }

    public void representativeAdded(DockController dockController, DockElementRepresentative dockElementRepresentative) {
        if (dockElementRepresentative.getElement().asDockable() != null) {
            ComponentObserver componentObserver = new ComponentObserver(dockElementRepresentative);
            this.listeners.put(dockElementRepresentative, componentObserver);
            dockElementRepresentative.addMouseInputListener(componentObserver);
        }
    }

    public void representativeRemoved(DockController dockController, DockElementRepresentative dockElementRepresentative) {
        ComponentObserver componentObserver;
        if (dockElementRepresentative.getElement().asDockable() != null && (componentObserver = this.listeners.remove(dockElementRepresentative)) != null) {
            dockElementRepresentative.removeMouseInputListener(componentObserver);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    private class ComponentObserver
    extends ActionPopup {
        private DockElementRepresentative representative;
        private boolean onMouseClick;

        public ComponentObserver(DockElementRepresentative dockElementRepresentative) {
            super(true);
            this.onMouseClick = false;
            this.representative = dockElementRepresentative;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.isMenuOpen()) {
                return;
            }
            if (this.isEnabled() && mouseEvent.getClickCount() == 1) {
                try {
                    this.onMouseClick = true;
                    this.popup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                finally {
                    this.onMouseClick = false;
                }
            }
        }

        protected Point getPopupLocation(Component component, Point point) {
            point = new Point(point);
            point = SwingUtilities.convertPoint(component, point, this.representative.getComponent());
            if ((point = this.representative.getPopupLocation(point, !this.onMouseClick)) == null) {
                return null;
            }
            point = new Point(point);
            return SwingUtilities.convertPoint(this.representative.getComponent(), point, component);
        }

        protected Dockable getDockable() {
            return this.representative.getElement().asDockable();
        }

        protected DockActionSource getSource() {
            return this.getDockable().getGlobalActionOffers();
        }

        protected boolean isEnabled() {
            return true;
        }
    }
}

