/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;

public class FocusController
implements DockRegisterListener {
    private StationListener listener = new StationListener();
    private DockController controller;

    public FocusController(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    public void dockStationRegistered(DockController dockController, DockStation dockStation) {
        dockStation.addDockStationListener(this.listener);
    }

    public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
        dockStation.removeDockStationListener(this.listener);
    }

    public void dockableUnregistered(DockController dockController, Dockable dockable) {
        if (dockable == dockController.getFocusedDockable()) {
            dockController.setFocusedDockable(null, false);
        }
    }

    public void dockStationRegistering(DockController dockController, DockStation dockStation) {
    }

    public void dockableRegistered(DockController dockController, Dockable dockable) {
    }

    public void dockableRegistering(DockController dockController, Dockable dockable) {
    }

    public void dockableCycledRegister(DockController dockController, Dockable dockable) {
    }

    private class StationListener
    extends DockStationAdapter {
        private StationListener() {
        }

        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            Dockable dockable2;
            if (!FocusController.this.controller.getRelocator().isOnPut() && (dockable == (dockable2 = FocusController.this.controller.getFocusedDockable()) || dockable2 == null) && dockStation.isVisible(dockable)) {
                FocusController.this.controller.setFocusedDockable(dockable, true);
            }
        }

        public void dockableVisibiltySet(DockStation dockStation, Dockable dockable, boolean bl) {
            if (!FocusController.this.controller.isOnFocusing() && !bl && FocusController.this.controller.isFocused(dockable)) {
                DockStation dockStation2 = dockable.getDockParent();
                while (dockStation2 != null && (dockable = dockStation2.asDockable()) != null) {
                    dockStation2 = dockable.getDockParent();
                    if (dockStation2 == null || !dockStation2.isVisible(dockable)) continue;
                    FocusController.this.controller.setFocusedDockable(dockable, false);
                    return;
                }
                FocusController.this.controller.setFocusedDockable(null, false);
            }
        }
    }
}

