/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.focus.DockableSelectionListener;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class DockableSelector {
    public static final PropertyKey<KeyStroke> INIT_SELECTION = new PropertyKey("dockable selector init selection keystroke");
    private PropertyValue<KeyStroke> initSelection = new PropertyValue<KeyStroke>(INIT_SELECTION){

        @Override
        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
        }
    };
    private Listener listener = new Listener();
    private DockController controller;
    private DockableSelection selection;
    private JDialog dialog;

    public void setController(DockController dockController) {
        this.cancel();
        if (this.controller != null) {
            this.controller.getKeyboardController().removeGlobalListener(this.listener);
        }
        this.controller = dockController;
        this.initSelection.setProperties(dockController);
        if (this.controller != null) {
            this.controller.getKeyboardController().addGlobalListener(this.listener);
        }
    }

    public void select() {
        this.cancel();
        this.open();
    }

    public void cancel() {
        this.close();
    }

    public void stop(Dockable dockable) {
        this.close();
        this.controller.setFocusedDockable(dockable, false);
    }

    private void open() {
        this.selection = this.controller.getTheme().getDockableSelection(this.controller);
        if (this.selection != null && this.selection.hasChoices(this.controller)) {
            Window window = this.controller.findRootWindow();
            if (this.dialog == null || this.dialog.getOwner() != window) {
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                if (window instanceof Frame) {
                    this.dialog = new JDialog((Frame)window, false);
                } else if (window instanceof Dialog) {
                    this.dialog = new JDialog((Dialog)window, false);
                } else {
                    this.dialog = new JDialog();
                    this.dialog.setModal(false);
                }
                this.dialog.setDefaultCloseOperation(0);
                this.dialog.setUndecorated(true);
                this.dialog.getRootPane().setWindowDecorationStyle(0);
                this.dialog.setLayout(new BorderLayout());
            }
            this.dialog.addWindowFocusListener(this.listener);
            this.selection.open(this.controller);
            Component component = this.selection.getComponent();
            this.dialog.add(component, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(window);
            this.selection.addDockableSelectionListener(this.listener);
            component.requestFocusInWindow();
            this.dialog.setVisible(true);
        } else {
            this.selection = null;
        }
    }

    private void close() {
        if (this.dialog != null) {
            if (this.selection != null) {
                this.dialog.removeWindowFocusListener(this.listener);
                this.selection.removeDockableSelectionListener(this.listener);
                this.selection.close();
                this.selection = null;
            }
            this.dialog.setVisible(false);
            this.dialog.getContentPane().removeAll();
        }
    }

    private class Listener
    implements KeyListener,
    DockableSelectionListener,
    WindowFocusListener {
        private Listener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(DockableSelector.this.initSelection.getValue())) {
                DockableSelector.this.select();
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(DockableSelector.this.initSelection.getValue())) {
                DockableSelector.this.select();
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(DockableSelector.this.initSelection.getValue())) {
                DockableSelector.this.select();
                keyEvent.consume();
            }
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            if (DockableSelector.this.selection != null) {
                DockableSelector.this.cancel();
            }
        }

        public void canceled() {
            DockableSelector.this.cancel();
        }

        public void considering(Dockable dockable) {
        }

        public void selected(Dockable dockable) {
            DockableSelector.this.stop(dockable);
        }
    }
}

