/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import java.awt.Component;
import java.awt.Dimension;

public class EclipseTabInfo
extends AbstractTabPaneComponent
implements CombinedInfoComponent,
LayoutBlock {
    private EclipseTabPane pane;
    private ButtonPanel buttons;
    private Dockable dockable;

    public EclipseTabInfo(EclipseTabPane eclipseTabPane) {
        super(eclipseTabPane);
        this.pane = eclipseTabPane;
        this.buttons = new ButtonPanel(true);
    }

    public void setSelection(Dockable dockable) {
        this.dockable = dockable;
        this.updateContent();
    }

    protected void updateContent() {
        if (this.dockable == null) {
            this.buttons.set(null, null);
        } else {
            EclipseDockActionSource eclipseDockActionSource = new EclipseDockActionSource(this.pane.getTheme(), this.dockable.getGlobalActionOffers(), this.dockable, false);
            this.buttons.set(this.dockable, eclipseDockActionSource);
        }
    }

    public Component getComponent() {
        return this.buttons;
    }

    public boolean isPaneVisible() {
        return this.pane.getInfoHandler().isVisible(this);
    }

    public void setPaneVisible(boolean bl) {
        this.pane.getInfoHandler().setVisible(this, bl);
    }

    public int getZOrder() {
        return this.pane.getInfoHandler().getZOrder(this);
    }

    public void setZOrder(int n) {
        this.pane.getInfoHandler().setZOrder(this, n);
    }

    public LayoutBlock toLayoutBlock() {
        return this;
    }

    public void setOrientation(TabPlacement tabPlacement) {
        super.setOrientation(tabPlacement);
        this.buttons.setOrientation(tabPlacement.toOrientation());
    }

    public Size[] getSizes() {
        Dimension[] dimensionArray = this.buttons.getPreferredSizes();
        Size[] sizeArray = new Size[dimensionArray.length];
        for (int i = 0; i < dimensionArray.length; ++i) {
            Size.Type type = i + 1 == dimensionArray.length ? Size.Type.PREFERRED : Size.Type.MINIMUM;
            sizeArray[i] = new CountingSize(type, dimensionArray[i], i);
        }
        return sizeArray;
    }

    public void setLayout(Size size) {
        if (!(size instanceof CountingSize)) {
            throw new IllegalArgumentException("size not created by this component");
        }
        this.buttons.setVisibleActions(((CountingSize)size).getCount());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.buttons.setBounds(n, n2, n3, n4);
    }

    private static class CountingSize
    extends Size {
        private int count;

        public CountingSize(Size.Type type, Dimension dimension, int n) {
            super(type, dimension);
            this.count = n;
        }

        public int getCount() {
            return this.count;
        }
    }
}

