/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.facile.menu.NodeMenuPiece;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import javax.swing.JMenu;

public class RootMenuPiece
extends NodeMenuPiece {
    private JMenu menu;
    private boolean disableWhenEmpty;

    public RootMenuPiece() {
        this(new JMenu());
    }

    public RootMenuPiece(String string, boolean bl, MenuPiece ... menuPieceArray) {
        this(new JMenu(string));
        this.setDisableWhenEmpty(bl);
        for (MenuPiece menuPiece : menuPieceArray) {
            this.add(menuPiece);
        }
    }

    public RootMenuPiece(JMenu jMenu) {
        if (jMenu == null) {
            throw new NullPointerException("menu must not be null");
        }
        this.menu = jMenu;
        this.addListener(new MenuPieceListener(){

            public void insert(MenuPiece menuPiece, int n, Component ... componentArray) {
                JMenu jMenu = RootMenuPiece.this.getMenu();
                for (int i = 0; i < componentArray.length; ++i) {
                    jMenu.add(componentArray[i], i + n);
                }
                jMenu.setEnabled(!RootMenuPiece.this.disableWhenEmpty || RootMenuPiece.this.getItemCount() > 0);
            }

            public void remove(MenuPiece menuPiece, int n, int n2) {
                JMenu jMenu = RootMenuPiece.this.getMenu();
                for (int i = n + n2 - 1; i >= n; --i) {
                    jMenu.remove(i);
                }
                jMenu.setEnabled(!RootMenuPiece.this.disableWhenEmpty || RootMenuPiece.this.getItemCount() > 0);
            }
        });
    }

    public void setDisableWhenEmpty(boolean bl) {
        this.disableWhenEmpty = bl;
        this.menu.setEnabled(!bl || this.getItemCount() > 0);
    }

    public boolean isDisableWhenEmpty() {
        return this.disableWhenEmpty;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public final void setParent(MenuPiece menuPiece) {
        throw new IllegalStateException("A root can't have any parent");
    }
}

