/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.facile.menu.CloseableDockableMenuPiece;

public class SingleCDockableListMenuPiece
extends CloseableDockableMenuPiece {
    private CControl control;
    private CloseableListenerManager closeableManager = new CloseableListenerManager();

    public SingleCDockableListMenuPiece(CControl cControl) {
        this.setControl(cControl);
    }

    public void setControl(CControl cControl) {
        if (this.control != cControl) {
            this.control = cControl;
            if (cControl == null) {
                this.setFrontend(null);
            } else {
                this.setFrontend(cControl.intern());
            }
        }
    }

    public void setFrontend(DockFrontend dockFrontend) {
        super.setFrontend(dockFrontend);
        this.closeableManager.setFrontend(dockFrontend);
    }

    protected void show(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().setVisible(true);
        } else {
            super.show(dockable);
        }
    }

    protected void hide(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().setVisible(false);
        } else {
            super.hide(dockable);
        }
    }

    protected boolean include(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().isCloseable();
        }
        return super.include(dockable);
    }

    private class CloseableListener
    extends CDockableAdapter {
        private CloseableListener() {
        }

        public void closeableChanged(CDockable cDockable) {
            SingleCDockableListMenuPiece.this.check(cDockable.intern());
        }
    }

    private class CloseableListenerManager
    extends DockFrontendAdapter {
        private CloseableListener listener;
        private DockFrontend frontend;

        private CloseableListenerManager() {
            this.listener = new CloseableListener();
        }

        public void setFrontend(DockFrontend dockFrontend) {
            if (this.frontend != dockFrontend) {
                if (this.frontend != null) {
                    this.frontend.removeFrontendListener(this);
                    for (Dockable dockable : dockFrontend.listDockables()) {
                        this.removed(this.frontend, dockable);
                    }
                }
                this.frontend = dockFrontend;
                if (this.frontend != null) {
                    this.frontend.addFrontendListener(this);
                    for (Dockable dockable : dockFrontend.listDockables()) {
                        this.added(this.frontend, dockable);
                    }
                }
            }
        }

        public void added(DockFrontend dockFrontend, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.listener);
            }
        }

        public void removed(DockFrontend dockFrontend, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.listener);
            }
        }
    }
}

