/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.station.AbstractResizeRequestHandler;
import bibliothek.gui.dock.common.intern.station.CLockedResizeLayoutManager;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import java.awt.Insets;

public class SplitResizeRequestHandler
extends AbstractResizeRequestHandler {
    private SplitDockStation station;

    public SplitResizeRequestHandler(SplitDockStation splitDockStation) {
        this.station = splitDockStation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResizeRequest(CControl cControl) {
        SplitLayoutManager splitLayoutManager = this.station.getSplitLayoutManager();
        LayoutManager layoutManager = new LayoutManager();
        try {
            layoutManager.setControl(cControl);
            this.station.setSplitLayoutManager(layoutManager);
            this.station.updateBounds();
        }
        finally {
            layoutManager.setControl(null);
            this.station.setSplitLayoutManager(splitLayoutManager);
        }
    }

    private class LayoutManager
    extends CLockedResizeLayoutManager {
        private LayoutManager() {
        }

        public void updateBounds(Root root, double d, double d2, double d3, double d4) {
            this.updateBoundsLocked(root, d, d2, d3, d4);
        }

        public RequestDimension prepareResize(Leaf leaf) {
            RequestDimension requestDimension = SplitResizeRequestHandler.this.getAndClearResizeRequest(leaf.getDockable());
            if (requestDimension != null) {
                Insets insets = leaf.getDisplayer().getDockableInsets();
                if (requestDimension.isWidthSet()) {
                    requestDimension.setWidth(requestDimension.getWidth() + insets.left + insets.right);
                }
                if (requestDimension.isHeightSet()) {
                    requestDimension.setHeight(requestDimension.getHeight() + insets.top + insets.bottom);
                }
                return requestDimension;
            }
            return super.prepareResize(leaf);
        }
    }
}

