/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.util.DockUtilities;

public interface CMaximizeBehavior {
    public static final CMaximizeBehavior TOPMOST = new CMaximizeBehavior(){

        public Dockable getMaximizingElement(Dockable dockable) {
            return dockable;
        }

        public Dockable getMaximizingElement(Dockable dockable, Dockable dockable2) {
            if (dockable2 == dockable) {
                return null;
            }
            return dockable;
        }
    };
    public static final CMaximizeBehavior STACKED = new CMaximizeBehavior(){

        public Dockable getMaximizingElement(Dockable dockable) {
            DockStation dockStation = dockable.getDockParent();
            if (dockStation instanceof StackDockStation) {
                int n = dockStation.getDockableCount();
                for (int i = 0; i < n; ++i) {
                    CDockable cDockable;
                    Dockable dockable2 = dockStation.getDockable(i);
                    if (dockable2 == dockable || !(dockable2 instanceof CommonDockable) || (cDockable = ((CommonDockable)dockable2).getDockable()).isMaximizable()) continue;
                    return dockable;
                }
                return (StackDockStation)dockStation;
            }
            return dockable;
        }

        public Dockable getMaximizingElement(Dockable dockable, Dockable dockable2) {
            if (dockable == dockable2) {
                return null;
            }
            if (!DockUtilities.isAncestor(dockable, dockable2)) {
                return null;
            }
            DockStation dockStation = dockable.asDockStation();
            if (dockStation == null) {
                return dockable;
            }
            if (dockStation.getDockableCount() == 2) {
                if (dockStation.getDockable(0) == dockable2) {
                    return dockStation.getDockable(1);
                }
                if (dockStation.getDockable(1) == dockable2) {
                    return dockStation.getDockable(0);
                }
            }
            return dockable;
        }
    };

    public Dockable getMaximizingElement(Dockable var1);

    public Dockable getMaximizingElement(Dockable var1, Dockable var2);
}

