% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope}
\alias{envelope}
\title{Calculates the envelope of a band limited signal}
\usage{
envelope(y)
}
\arguments{
\item{y}{numeric vector of the signal}
}
\value{
real valued envelope function of the signal
}
\description{
The envelope of an amplitude modulated signal can be calculated by using the
Hilbert-transform \eqn{H(y)} of the signal or the analytic signal.
}
\details{
An amplitude  modulated function \eqn{y(x) = A(x) * cos(\omega * x)} can be
demodulated as follows:

\deqn{A(x)^2 = y(x)^2 + H(y(x))^2}

If the signal is not band limited, strange things can happen. See the ripple
at the edges in the example below. Pay attention, that the envelope is always
the real part of the returned value.
}
\examples{
## noisy signal with amplitude modulation
x <- seq(0,1, length.out=2e2)

# original data
y <- (abs(x-0.5))*sin(20*2*pi*x)

ye <- base::Re(envelope(y))

# plot results
plot(x,y,type="l",lwd=1,col="darkgrey",lty=2,ylab="y",main="Spectral filtering")
lines(x,ye)
legend("bottomright",c("modulated","envelope"),col=c("grey","black"),lty=c(2,1))
}
