% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spdur.R
\name{plot.spdur}
\alias{plot.spdur}
\title{Plot split-duration model results.}
\usage{
\method{plot}{spdur}(x, type = "sepplot", ci = TRUE, ...)
}
\arguments{
\item{x}{An object of class "\code{spdur}".}

\item{type}{What kind of plot? "sepplot" or "hazard".}

\item{ci}{For plots of the hazard rate, should a confidence interval be included?}

\item{\dots}{Optional parameters passed to \code{\link{sepplot}}
or \code{\link{plot_hazard}}.}
}
\description{
Plot results from a spduration model. Two types are currently implemented:
a separation plot for evaluating model predictions ("sepplot"), and a plot of 
the conditional hazard rate ("hazard"), with or without simulation-based
confidence intervals.
}
\examples{
# get model estimates
data(model.coups)

# plot
plot(model.coups, type = "hazard")

plot(model.coups)

}
\seealso{
\code{\link{sepplot}}, \code{\link{plot_hazard}}
}
