% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsing.R
\name{occurrences}
\alias{occurrences}
\title{Extract or set attribute level occurrences}
\usage{
occurrences(x, rows)
}
\arguments{
\item{x}{An object of class 'utility' or 'spdesign'}

\item{rows}{Number of rows in the design}
}
\value{
A named list of lists where the outer list is for the attributes and
the inner list, the levels of each attribute and the number or range of times
they can occur
}
\description{
This function will set the range of attribute level occurrences equal to to
the size of the design. This is equivalent to fully letting go of attribute
level balance. Letting go of attribute level balance is the default behavior
for the Modified Federov algorithm and the Random algorithm.
}
\details{
If restrictions are placed on attribute level occurrence in the utility
function, then this function will extract these and add them to the output.

Notice that specifying restrictions in the utility function only matters for
the Modified Federov and Random algorithms and will in general result in a
less efficient design.
}
