% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{SPCModelNonparCenterScale}
\alias{SPCModelNonparCenterScale}
\title{Nonparametric Resampling with Centering and Scaling}
\usage{
SPCModelNonparCenterScale(Delta = 0)
}
\arguments{
\item{Delta}{how much to subtract before scaling.}
}
\value{
An object of class SPCDataModel.

An object of class SPCDataModel.
}
\description{
Nonparametric resampling of univariate observations. Updates are
centered and scaled transformations of the data (with a constant
potentially being subtracted).
}
\details{
Calls \code{\link{SPCModelNonpar}} to generate the data object, so it only needs to specify the meaning of \code{xi}, the parameter needed to compute updates and the definition of the updates.
\itemize{
\item xi: a list with two elements:
      \itemize{
      \item mu: the mean.
      \item sd: the standard deviation.
      }
\item updates(xi,data): returns the centered and scale version of the data from which \eqn{Delta/2} has been subtracted, i.e.
 \deqn{\frac{data-mu-Delta/2}{sd}}{(data-mu-Delta/2)/sd}
}
}
\examples{
X <- rnorm(1000)

#CUSUM chart
model <- SPCModelNonparCenterScale(1)
chart <- new("SPCCUSUM",model=model)
SPCproperty(data=X,nrep=10,property="calARL",
            chart=chart,params=list(target=100))

#Shewhart chart
model <- SPCModelNonparCenterScale(0)
chart <- new("SPCCUSUM",model=model)
SPCproperty(data=X,nrep=10,property="calARL",
            chart=chart,params=list(target=100))
}
\seealso{
\code{\link{SPCModelNonpar}}
}

