\name{colourmap}
\alias{colourmap}
\title{Colour Lookup Tables}
\description{
  Create a colour map (colour lookup table).
}
\usage{
colourmap(col, ..., breaks=NULL, inputs=NULL)
}
\arguments{
  \item{col}{Character vector specifying colours}
  \item{\dots}{Ignored.}
  \item{inputs}{
    Values to which the colours are associated.
    A factor or vector of the same length as \code{col}.
    Incompatible with \code{breaks}.
  }
  \item{breaks}{
    Breakpoints for the colour map.
    A numeric vector of length equal to \code{length(col)+1}.
  }
}
\details{
  A colour map is a mechanism for associating colours with data.
  It can be regarded as a function, mapping data to colours.

  The command \code{colourmap} creates an object representing
  a colour map, which can then be used to control the plot commands
  in the \pkg{spatstat} package. It can also be used to compute the
  colour assigned to any data value. 

  The argument \code{col} specifies the colours to which
  data values will be mapped. It should be a character vector
  whose entries can be interpreted as colours.

  Exactly one of the arguments \code{inputs} and \code{breaks}
  must be specified by name.

  If \code{inputs} is given, then it should be a vector or factor,
  of the same length as \code{col}. The entries of \code{inputs} can be
  any atomic type (e.g. numeric, logical, character, complex) or factor
  values. The resulting colour map associates the value \code{inputs[i]}
  with the colour \code{col[i]}.

  If \code{breaks} is given, then it determines intervals
  of the real number line
  which are mapped to each colour. It should be a numeric vector,
  of length at least 2, with entries that are in increasing order.
  Infinite values are allowed. Any number in the range
  between \code{breaks[i]} and \code{breaks[i+1]} will be mapped to the
  colour \code{col[i]}. 

  The result is an object of class \code{"colourmap"}. 
  There are \code{print} and \code{plot} methods for this class.
  Some plot commands in the \pkg{spatstat} package accept an object
  of this class as a specification of the colour map.

  The result is also a function \code{f} which can be used to compute
  the colour assigned to any data value. 
  That is, \code{f(x)} returns the character value of the colour assigned
  to \code{x}. This also works for vectors of data values.
}
\value{
  A function, which is also an object of class \code{"colourmap"}.
}
\seealso{
  The plot method \code{\link{plot.colourmap}}.
  
  See \code{\link[grDevices:colors]{colours}} for information about the colours
  that \R recognises, and how to manipulate them.

  See \code{\link{lut}} for lookup tables.
}
\examples{
  # colour map for real numbers, using breakpoints
  cr <- colourmap(c("red", "blue", "green"), breaks=c(0,5,10,15))
  cr
  cr(3.2)
  cr(c(3,5,7))
  # a large colour map
  co <- colourmap(rainbow(100), breaks=seq(-1,1,length=101))
  co(0.2)
  # colour map for discrete set of values
  ct <- colourmap(c("red", "green"), inputs=c(FALSE, TRUE))
  ct(TRUE)
}
\author{Adrian Baddeley
  \email{adrian@maths.uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
\keyword{color}
